/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class RedmineWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public RedmineWeb(String repoUrl) {
        super(repoUrl);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, "diff?rev=" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        URL changeSetLink = new URL(url, "revisions/" + changeSet.getId());
        URL difflink = path.getEditType().equals(EditType.ADD) ? this.getFileLink(path) : new URL(changeSetLink, changeSetLink.getPath() + "/diff/" + path.getPath());
        return difflink;
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLink(path);
        }
        String spec = "revisions/" + path.getChangeSet().getId() + "/entry/" + path.getPath();
        URL url = this.getUrl();
        return new URL(url, url.getPath() + spec);
    }

    @Extension
    public static class RedmineWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @Nonnull
        public String getDisplayName() {
            return "redmineweb";
        }

        public RedmineWeb newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (RedmineWeb)((Object)req.bindJSON(RedmineWeb.class, jsonObject));
        }
    }
}

