/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.dtkit.model;

import com.sun.xml.bind.AnyTypeAdapter;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.jenkinsci.lib.dtkit.model.InputMetricType;
import org.jenkinsci.lib.dtkit.model.InputType;
import org.jenkinsci.lib.dtkit.model.OutputMetric;
import org.jenkinsci.lib.dtkit.util.converter.ConversionException;
import org.jenkinsci.lib.dtkit.util.validator.ValidationError;
import org.jenkinsci.lib.dtkit.util.validator.ValidationException;

@XmlJavaTypeAdapter(value=AnyTypeAdapter.class)
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class InputMetric
implements Serializable {
    private String toolName;
    private String toolVersion;
    private InputMetricType inputMetricType;
    private InputType toolType;
    private OutputMetric outputFormatType;
    private List<ValidationError> inputValidationErrors = new ArrayList<ValidationError>();
    private List<ValidationError> outputValidationErrors = new ArrayList<ValidationError>();

    @XmlElement
    public String getToolName() {
        return this.toolName;
    }

    @XmlElement
    public String getToolVersion() {
        return this.toolVersion;
    }

    @JsonIgnore
    public boolean isDefault() {
        return false;
    }

    @JsonIgnore
    public String getLabel() {
        String label = this.getToolVersion() == null ? this.getToolName() : this.getToolName() + "-" + this.getToolVersion();
        if (this.isDefault()) {
            label = label + " (default)";
        }
        return label;
    }

    @JsonIgnore
    public InputMetricType getInputMetricType() {
        return this.inputMetricType;
    }

    @XmlElement
    public InputType getToolType() {
        return this.toolType;
    }

    @XmlElement
    public OutputMetric getOutputFormatType() {
        return this.outputFormatType;
    }

    public void convert(File inputFile, File outFile) throws ConversionException {
        this.convert(inputFile, outFile, null);
    }

    public abstract void convert(File var1, File var2, Map<String, Object> var3) throws ConversionException;

    public abstract boolean validateInputFile(File var1) throws ValidationException;

    public abstract boolean validateOutputFile(File var1) throws ValidationException;

    @JsonIgnore
    public List<ValidationError> getInputValidationErrors() {
        return this.inputValidationErrors;
    }

    @JsonIgnore
    public List<ValidationError> getOutputValidationErrors() {
        return this.outputValidationErrors;
    }

    public void setInputValidationErrors(List<ValidationError> inputValidationErrors) {
        this.inputValidationErrors = inputValidationErrors;
    }

    public void setOutputValidationErrors(List<ValidationError> outputValidationErrors) {
        this.outputValidationErrors = outputValidationErrors;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    @JsonIgnore
    public void setLabel(String label) {
    }

    public void setInputMetricType(InputMetricType inputMetricType) {
        this.inputMetricType = inputMetricType;
    }

    public void setToolType(InputType toolType) {
        this.toolType = toolType;
    }

    @JsonIgnore
    public void setOutputFormatType(OutputMetric outputFormatType) {
        this.outputFormatType = outputFormatType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputMetric that = (InputMetric)o;
        if (this.getInputMetricType() != that.getInputMetricType()) {
            return false;
        }
        if (this.getToolName() != null ? !this.getToolName().equals(that.getToolName()) : that.getToolName() != null) {
            return false;
        }
        if (this.getToolType() != that.getToolType()) {
            return false;
        }
        return !(this.getToolVersion() != null ? !this.getToolVersion().equals(that.getToolVersion()) : that.getToolVersion() != null);
    }

    public int hashCode() {
        int result = this.getToolName() != null ? this.getToolName().hashCode() : 0;
        result = 31 * result + (this.getToolVersion() != null ? this.getToolVersion().hashCode() : 0);
        result = 31 * result + (this.getInputMetricType() != null ? this.getInputMetricType().hashCode() : 0);
        result = 31 * result + (this.getToolType() != null ? this.getToolType().hashCode() : 0);
        return result;
    }
}

