/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.dtkit.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.jenkinsci.lib.dtkit.model.InputMetric;
import org.jenkinsci.lib.dtkit.model.InputMetricType;
import org.jenkinsci.lib.dtkit.util.converter.ConversionException;
import org.jenkinsci.lib.dtkit.util.converter.ConversionService;
import org.jenkinsci.lib.dtkit.util.validator.ValidationException;
import org.jenkinsci.lib.dtkit.util.validator.ValidationService;

public abstract class InputMetricXSL
extends InputMetric {
    private String xslName;
    private File xslFile;
    private String[] inputXsdNameList;
    private File[] inputXsdFileList;

    @JsonIgnore
    public Class getXslResourceClass() {
        return this.getClass();
    }

    @JsonIgnore
    public Class getInputXsdClass() {
        return this.getClass();
    }

    @JsonIgnore
    public String getXslName() {
        return this.xslName;
    }

    @JsonIgnore
    public File getXslFile() {
        return this.xslFile;
    }

    @JsonIgnore
    public InputStream getXslInputStream() throws IOException {
        if (this.getXslFile() != null) {
            return new FileInputStream(this.getXslFile());
        }
        if (this.getXslName() != null) {
            return this.getXslResourceClass().getResourceAsStream(this.getXslName());
        }
        return null;
    }

    @JsonIgnore
    public String[] getInputXsdNameList() {
        return this.inputXsdNameList;
    }

    @JsonIgnore
    public File[] getInputXsdFileList() {
        return this.inputXsdFileList;
    }

    @JsonIgnore
    public InputStream[] getListXsdInputStream() throws IOException {
        File[] inputXsdFileList = this.getInputXsdFileList();
        if (inputXsdFileList != null) {
            InputStream[] inputStreams = new InputStream[inputXsdFileList.length];
            for (int i = 0; i < inputXsdFileList.length; ++i) {
                inputStreams[i] = new FileInputStream(inputXsdFileList[i]);
            }
            return inputStreams;
        }
        String[] inputXsdNameList = this.getInputXsdNameList();
        if (inputXsdNameList != null) {
            InputStream[] inputStreams = new InputStream[inputXsdNameList.length];
            for (int i = 0; i < inputXsdNameList.length; ++i) {
                inputStreams[i] = this.getInputXsdClass().getResourceAsStream(inputXsdNameList[i]);
            }
            return inputStreams;
        }
        return null;
    }

    @JsonIgnore
    public String[] getOutputXsdNameList() {
        if (this.getOutputFormatType() == null) {
            return null;
        }
        return this.getOutputFormatType().getXsdNameList();
    }

    @Override
    public InputMetricType getInputMetricType() {
        return InputMetricType.XSL;
    }

    public String getUserContentXSLDirRelativePath() {
        if (this.getToolVersion() == null || this.getToolVersion().endsWith("N/A")) {
            return "xunit/" + this.getToolName() + "/";
        }
        return "xunit/" + this.getToolName() + "/" + this.getToolVersion();
    }

    @Override
    public void convert(File inputFile, File outFile, Map<String, Object> params) throws ConversionException {
        ConversionService conversionService = new ConversionService();
        if (this.getXslFile() == null) {
            conversionService.convert(new StreamSource(this.getXslResourceClass().getResourceAsStream(this.getXslName())), inputFile, outFile, params);
        } else {
            conversionService.convert(this.getXslFile(), inputFile, outFile, params);
        }
    }

    @Override
    public void convert(File inputFile, File outFile) throws ConversionException {
        this.convert(inputFile, outFile, null);
    }

    public void convert(File inputFile, File outFile, File externalXsl, Map<String, Object> params) throws ConversionException {
        ConversionService conversionService = new ConversionService();
        conversionService.convert(externalXsl, inputFile, outFile, params);
    }

    public void convert(File inputFile, File outFile, String externalXslContent, Map<String, Object> params) throws ConversionException {
        ConversionService conversionService = new ConversionService();
        conversionService.convert(new StreamSource(new StringReader(externalXslContent)), inputFile, outFile, params);
    }

    @Override
    public boolean validateInputFile(File inputXMLFile) throws ValidationException {
        ValidationService validationService = new ValidationService();
        if (this.getInputXsdNameList() == null && this.getInputXsdFileList() == null) {
            return true;
        }
        if (this.getInputXsdFileList() != null) {
            this.setInputValidationErrors(validationService.processValidation(this.getInputXsdFileList(), inputXMLFile));
        }
        if (this.getInputXsdNameList() != null) {
            Source[] streamSources = new StreamSource[this.getInputXsdNameList().length];
            for (int i = 0; i < streamSources.length; ++i) {
                streamSources[i] = new StreamSource(this.getInputXsdClass().getResourceAsStream(this.getInputXsdNameList()[i]));
            }
            this.setInputValidationErrors(validationService.processValidation(streamSources, inputXMLFile));
        }
        return this.getInputValidationErrors().size() == 0;
    }

    @Override
    public boolean validateOutputFile(File inputXMLFile) throws ValidationException {
        if (this.getOutputFormatType() == null) {
            return true;
        }
        if (this.getOutputXsdNameList() == null) {
            return true;
        }
        Source[] sources = new Source[this.getOutputXsdNameList().length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = new StreamSource(this.getOutputFormatType().getClass().getResourceAsStream(this.getOutputXsdNameList()[i]));
        }
        ValidationService validationService = new ValidationService();
        this.setOutputValidationErrors(validationService.processValidation(sources, inputXMLFile));
        return this.getOutputValidationErrors().size() == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InputMetricXSL that = (InputMetricXSL)o;
        if (!Arrays.equals(this.inputXsdFileList, that.inputXsdFileList)) {
            return false;
        }
        if (!Arrays.equals(this.inputXsdNameList, that.inputXsdNameList)) {
            return false;
        }
        if (this.xslFile != null ? !this.xslFile.equals(that.xslFile) : that.xslFile != null) {
            return false;
        }
        return !(this.xslName != null ? !this.xslName.equals(that.xslName) : that.xslName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.xslName != null ? this.xslName.hashCode() : 0);
        result = 31 * result + (this.xslFile != null ? this.xslFile.hashCode() : 0);
        result = 31 * result + (this.inputXsdNameList != null ? Arrays.hashCode(this.inputXsdNameList) : 0);
        result = 31 * result + (this.inputXsdFileList != null ? Arrays.hashCode(this.inputXsdFileList) : 0);
        return result;
    }
}

