/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount;

import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.sloccount.Messages;
import hudson.plugins.sloccount.SloccountDiffSummary;
import hudson.plugins.sloccount.SloccountProjectAction;
import hudson.plugins.sloccount.SloccountResult;
import hudson.plugins.sloccount.model.SloccountReportStatistics;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerProxy;

public class SloccountBuildAction
implements RunAction2,
StaplerProxy,
SimpleBuildStep.LastBuildAction {
    public static final String URL_NAME = "sloccountResult";
    private transient Run<?, ?> build;
    private final SloccountResult result;
    private final int numBuildsInGraph;
    private transient List<SloccountProjectAction> projectActions;

    public SloccountBuildAction(SloccountResult result, int numBuildsInGraph) {
        this.result = result;
        this.numBuildsInGraph = numBuildsInGraph;
    }

    public String getIconFileName() {
        return "/plugin/sloccount/icons/sloccount-24.png";
    }

    public String getDisplayName() {
        return Messages.Sloccount_SloccountResults();
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public Collection<? extends Action> getProjectActions() {
        this.buildProjectActions();
        return Collections.unmodifiableList(this.projectActions);
    }

    private void buildProjectActions() {
        if (this.projectActions != null) {
            return;
        }
        CopyOnWriteArrayList<SloccountProjectAction> actions = new CopyOnWriteArrayList<SloccountProjectAction>();
        actions.add(new SloccountProjectAction(this.build.getParent(), this.numBuildsInGraph));
        this.projectActions = actions;
    }

    public SloccountDiffSummary getDiffSummary() {
        return SloccountDiffSummary.getDiffSummary(this.getPreviousStatistics(), this.result.getStatistics());
    }

    public SloccountResult getResult() {
        return this.result;
    }

    private SloccountReportStatistics getPreviousStatistics() {
        SloccountResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getStatistics();
    }

    SloccountResult getPreviousResult() {
        SloccountBuildAction previousAction = this.getPreviousAction();
        SloccountResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    SloccountBuildAction getPreviousAction() {
        if (this.build == null) {
            return null;
        }
        for (Run previousBuild = this.build.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
            SloccountResult result;
            SloccountBuildAction action = (SloccountBuildAction)previousBuild.getAction(SloccountBuildAction.class);
            if (action == null || (result = action.getResult()) == null || result.isEmpty()) continue;
            return action;
        }
        return null;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }

    public void onLoad(Run<?, ?> r) {
        this.build = r;
        this.result.setOwner(r);
        this.buildProjectActions();
    }

    public void onAttached(Run<?, ?> r) {
        this.build = r;
        this.buildProjectActions();
    }
}

