/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount;

import hudson.plugins.sloccount.Messages;
import hudson.plugins.sloccount.SloccountAreaRenderer;
import hudson.plugins.sloccount.SloccountBuildAction;
import hudson.plugins.sloccount.SloccountResult;
import hudson.plugins.sloccount.model.SloccountLanguageStatistics;
import hudson.plugins.sloccount.model.SloccountReportStatistics;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.HashSet;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class SloccountChartBuilder
implements Serializable {
    private static final long serialVersionUID = 0L;

    private SloccountChartBuilder() {
    }

    public static JFreeChart buildChart(SloccountBuildAction action, int numBuildsInGraph) {
        String strLines = Messages.Sloccount_Trend_LinesTotal();
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)strLines, (CategoryDataset)SloccountChartBuilder.buildDataset(action, numBuildsInGraph), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        SloccountAreaRenderer renderer = new SloccountAreaRenderer(action.getUrlName());
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }

    private static CategoryDataset buildDataset(SloccountBuildAction lastAction, int numBuildsInGraph) {
        DataSetBuilder builder = new DataSetBuilder();
        HashSet<String> allLanguages = new HashSet<String>();
        int numBuilds = 0;
        for (SloccountBuildAction action = lastAction; action != null && (numBuildsInGraph <= 1 || numBuilds < numBuildsInGraph); action = action.getPreviousAction()) {
            SloccountResult result = action.getResult();
            if (result == null) continue;
            ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(action.getBuild());
            allLanguages.addAll(result.getStatistics().getAllLanguages());
            HashSet remainingLanguages = new HashSet(allLanguages);
            for (SloccountLanguageStatistics l : result.getStatistics().getStatistics()) {
                builder.add((Number)l.getLineCount(), (Comparable)((Object)l.getName()), (Comparable)buildLabel);
                remainingLanguages.remove(l.getName());
            }
            for (String language : remainingLanguages) {
                builder.add((Number)0, (Comparable)((Object)language), (Comparable)buildLabel);
            }
            ++numBuilds;
        }
        return builder.build();
    }

    public static JFreeChart buildChartDelta(SloccountBuildAction action, int numBuildsInGraph) {
        String strLinesDelta = Messages.Sloccount_Trend_LinesDelta();
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)strLinesDelta, (CategoryDataset)SloccountChartBuilder.buildDatasetDelta(action, numBuildsInGraph), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        SloccountAreaRenderer renderer = new SloccountAreaRenderer(action.getUrlName());
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }

    private static CategoryDataset buildDatasetDelta(SloccountBuildAction lastAction, int numBuildsInGraph) {
        DataSetBuilder builder = new DataSetBuilder();
        HashSet<String> allLanguages = new HashSet<String>();
        SloccountBuildAction action = lastAction;
        if (action != null && action.getResult() != null) {
            allLanguages.addAll(action.getResult().getStatistics().getAllLanguages());
        }
        int numBuilds = 0;
        while (action != null && (numBuildsInGraph <= 1 || numBuilds < numBuildsInGraph)) {
            SloccountBuildAction previousAction = action.getPreviousAction();
            SloccountResult result = action.getResult();
            if (result != null) {
                SloccountLanguageStatistics previous;
                ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(action.getBuild());
                SloccountReportStatistics previousStatistics = previousAction != null && previousAction.getResult() != null ? previousAction.getResult().getStatistics() : result.getStatistics();
                allLanguages.addAll(previousStatistics.getAllLanguages());
                HashSet remainingLanguages = new HashSet(allLanguages);
                for (SloccountLanguageStatistics current : result.getStatistics().getStatistics()) {
                    previous = previousStatistics.getLanguage(current.getName());
                    builder.add((Number)(current.getLineCount() - previous.getLineCount()), (Comparable)((Object)current.getName()), (Comparable)buildLabel);
                    remainingLanguages.remove(current.getName());
                }
                for (String language : remainingLanguages) {
                    previous = previousStatistics.getLanguage(language);
                    builder.add((Number)(-previous.getLineCount()), (Comparable)((Object)language), (Comparable)buildLabel);
                }
                ++numBuilds;
            }
            action = previousAction;
        }
        return builder.build();
    }
}

