/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount;

import hudson.plugins.sloccount.util.StringUtil;

public abstract class SloccountDiff
implements Comparable<SloccountDiff> {
    private final int lineCount;
    private final int lineCountDelta;
    private final int fileCount;
    private final int fileCountDelta;
    private final int commentCount;
    private final int commentCountDelta;

    public SloccountDiff(int lineCount, int lineCountDelta, int fileCount, int fileCountDelta, int commentCount, int commentCountDelta) {
        this.lineCount = lineCount;
        this.lineCountDelta = lineCountDelta;
        this.fileCount = fileCount;
        this.fileCountDelta = fileCountDelta;
        this.commentCount = commentCount;
        this.commentCountDelta = commentCountDelta;
    }

    @Override
    public int compareTo(SloccountDiff o) {
        return o.lineCount - this.lineCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lineCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SloccountDiff other = (SloccountDiff)obj;
        return this.lineCount == other.lineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getLineCountDelta() {
        return this.lineCountDelta;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public int getCommentCountDelta() {
        return this.commentCountDelta;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getFileCountDelta() {
        return this.fileCountDelta;
    }

    public String getLineCountString() {
        return StringUtil.grouping(this.lineCount);
    }

    public String getLineCountDeltaString() {
        if (this.lineCountDelta == 0) {
            return "";
        }
        String result = StringUtil.grouping(this.lineCountDelta);
        return this.lineCountDelta > 0 ? "+" + result : result;
    }

    public String getCommentCountString() {
        return StringUtil.grouping(this.commentCount);
    }

    public String getCommentCountDeltaString() {
        if (this.commentCountDelta == 0) {
            return "";
        }
        String result = StringUtil.grouping(this.commentCountDelta);
        return this.commentCountDelta > 0 ? "+" + result : result;
    }

    public String getFileCountString() {
        return StringUtil.grouping(this.fileCount);
    }

    public String getFileCountDeltaString() {
        if (this.fileCountDelta == 0) {
            return "";
        }
        String result = StringUtil.grouping(this.fileCountDelta);
        return this.fileCountDelta > 0 ? "+" + result : result;
    }
}

