/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount;

import hudson.plugins.sloccount.SloccountDiff;
import hudson.plugins.sloccount.SloccountDiffLanguage;
import hudson.plugins.sloccount.model.SloccountLanguageStatistics;
import hudson.plugins.sloccount.model.SloccountReportStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class SloccountDiffSummary
extends SloccountDiff {
    private final List<SloccountDiffLanguage> languageDiffs;

    private SloccountDiffSummary(List<SloccountDiffLanguage> languageDiffs, int lineCount, int lineCountDelta, int fileCount, int fileCountDelta, int commentCount, int commentCountDelta) {
        super(lineCount, lineCountDelta, fileCount, fileCountDelta, commentCount, commentCountDelta);
        this.languageDiffs = languageDiffs;
        Collections.sort(this.languageDiffs);
    }

    public static SloccountDiffSummary getDiffSummary(SloccountReportStatistics previous, SloccountReportStatistics current) {
        if (previous == null) {
            return SloccountDiffSummary.getDiffSummary(current);
        }
        HashSet<String> languages = new HashSet<String>();
        languages.addAll(previous.getAllLanguages());
        languages.addAll(current.getAllLanguages());
        ArrayList<SloccountDiffLanguage> result = new ArrayList<SloccountDiffLanguage>();
        int lineCount = 0;
        int lineCountDelta = 0;
        int fileCount = 0;
        int fileCountDelta = 0;
        int commentCount = 0;
        int commentCountDelta = 0;
        for (String language : languages) {
            SloccountLanguageStatistics curStats = current.getLanguage(language);
            SloccountLanguageStatistics prevStats = previous.getLanguage(language);
            result.add(new SloccountDiffLanguage(curStats.getName(), curStats.getLineCount(), curStats.getLineCount() - prevStats.getLineCount(), curStats.getFileCount(), curStats.getFileCount() - prevStats.getFileCount(), curStats.getCommentCount(), curStats.getCommentCount() - prevStats.getCommentCount()));
            lineCount += curStats.getLineCount();
            lineCountDelta += curStats.getLineCount() - prevStats.getLineCount();
            fileCount += curStats.getFileCount();
            fileCountDelta += curStats.getFileCount() - prevStats.getFileCount();
            commentCount += curStats.getCommentCount();
            commentCountDelta += curStats.getCommentCount() - prevStats.getCommentCount();
        }
        return new SloccountDiffSummary(result, lineCount, lineCountDelta, fileCount, fileCountDelta, commentCount, commentCountDelta);
    }

    private static SloccountDiffSummary getDiffSummary(SloccountReportStatistics current) {
        if (current == null) {
            return SloccountDiffSummary.getDiffSummary();
        }
        ArrayList<SloccountDiffLanguage> result = new ArrayList<SloccountDiffLanguage>();
        int lineCount = 0;
        int fileCount = 0;
        int commentCount = 0;
        for (SloccountLanguageStatistics language : current.getStatistics()) {
            result.add(new SloccountDiffLanguage(language.getName(), language.getLineCount(), 0, language.getFileCount(), 0, language.getCommentCount(), 0));
            lineCount += language.getLineCount();
            fileCount += language.getFileCount();
            commentCount += language.getCommentCount();
        }
        return new SloccountDiffSummary(result, lineCount, 0, fileCount, 0, commentCount, 0);
    }

    private static SloccountDiffSummary getDiffSummary() {
        return new SloccountDiffSummary(Collections.emptyList(), 0, 0, 0, 0, 0, 0);
    }

    public List<SloccountDiffLanguage> getLanguageDiffs() {
        return Collections.unmodifiableList(this.languageDiffs);
    }
}

