/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.sloccount.Messages;
import hudson.plugins.sloccount.SloccountBuildAction;
import hudson.plugins.sloccount.SloccountChartBuilder;
import hudson.plugins.sloccount.SloccountResult;
import hudson.util.ChartUtil;
import java.io.IOException;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SloccountProjectAction
implements Action {
    public static final String URL_NAME = "sloccountResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    public transient Job<?, ?> project;
    private final int numBuildsInGraph;

    public SloccountProjectAction(Job<?, ?> project, int numBuildsInGraph) {
        this.project = project;
        this.numBuildsInGraph = numBuildsInGraph;
    }

    public String getIconFileName() {
        return "/plugin/sloccount/icons/sloccount-24.png";
    }

    public String getDisplayName() {
        return Messages.Sloccount_SloccountResults();
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        Run<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), URL_NAME));
        } else {
            response.sendRedirect2("..");
        }
    }

    public Run<?, ?> getLastFinishedBuild() {
        Run lastBuild;
        for (lastBuild = this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(SloccountBuildAction.class) == null); lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public SloccountBuildAction getLastFinishedBuildAction() {
        Run<?, ?> lastBuild = this.getLastFinishedBuild();
        return lastBuild != null ? (SloccountBuildAction)lastBuild.getAction(SloccountBuildAction.class) : null;
    }

    public final boolean hasValidResults() {
        Run<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            int nbr_results = 0;
            for (SloccountBuildAction resultAction = (SloccountBuildAction)build.getAction(SloccountBuildAction.class); resultAction != null; resultAction = resultAction.getPreviousAction()) {
                SloccountResult result = resultAction.getResult();
                if (result == null || ++nbr_results <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        SloccountBuildAction lastAction = this.getLastFinishedBuildAction();
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)SloccountChartBuilder.buildChart(lastAction, this.numBuildsInGraph), (int)500, (int)200);
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        SloccountBuildAction lastAction = this.getLastFinishedBuildAction();
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)SloccountChartBuilder.buildChart(lastAction, this.numBuildsInGraph), (int)500, (int)200);
    }

    public void doTrendDeltaMap(StaplerRequest request, StaplerResponse response) throws IOException {
        SloccountBuildAction lastAction = this.getLastFinishedBuildAction();
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)SloccountChartBuilder.buildChartDelta(lastAction, this.numBuildsInGraph), (int)500, (int)200);
    }

    public void doTrendDelta(StaplerRequest request, StaplerResponse response) throws IOException {
        SloccountBuildAction lastAction = this.getLastFinishedBuildAction();
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)SloccountChartBuilder.buildChartDelta(lastAction, this.numBuildsInGraph), (int)500, (int)200);
    }
}

