/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sloccount.SloccountBuildAction;
import hudson.plugins.sloccount.SloccountResult;
import hudson.plugins.sloccount.model.SloccountParser;
import hudson.plugins.sloccount.model.SloccountPublisherReport;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class SloccountPublisher
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final String BUILD_SUBDIR = "sloccount-plugin";
    private static final String DEFAULT_PATTERN = "**/sloccount.sc";
    static final String DEFAULT_ENCODING = "UTF-8";
    private final String pattern;
    private final String encoding;
    private final boolean commentIsCode;
    private final int numBuildsInGraph;
    private final boolean ignoreBuildFailure;

    @DataBoundConstructor
    public SloccountPublisher(String pattern, String encoding, boolean commentIsCode, int numBuildsInGraph, boolean ignoreBuildFailure) {
        this.pattern = pattern;
        this.encoding = encoding;
        this.commentIsCode = commentIsCode;
        this.numBuildsInGraph = numBuildsInGraph;
        this.ignoreBuildFailure = ignoreBuildFailure;
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) {
        SloccountPublisherReport report;
        PrintStream logger = listener.getLogger();
        if (!this.canContinue(build.getResult())) {
            if (this.ignoreBuildFailure) {
                logger.println("[SLOCCount] Trying to process the report files even if the build is not successful");
            } else {
                logger.println("[SLOCCount] Skipping results publication since the build is not successful");
                return;
            }
        }
        SloccountParser parser = new SloccountParser(this.getRealEncoding(), this.getRealPattern(), logger, this.commentIsCode);
        try {
            report = (SloccountPublisherReport)workspace.act((FilePath.FileCallable)parser);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(logger);
            return;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(logger);
            return;
        }
        if (report.getSourceFiles().size() == 0) {
            logger.format("[SLOCCount] No file is matching the input pattern: %s%n", this.getRealPattern());
            return;
        }
        SloccountResult result = new SloccountResult(report.getStatistics(), this.getRealEncoding(), this.commentIsCode, null, build);
        build.addAction((Action)new SloccountBuildAction(result, this.numBuildsInGraph));
        try {
            this.copyFilesToBuildDirectory(report.getSourceFiles(), build.getRootDir(), launcher.getChannel());
        }
        catch (IOException e) {
            e.printStackTrace(logger);
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace(logger);
            return;
        }
        logger.format("[SLOCCount] Report successfully processed and all data stored%n", new Object[0]);
    }

    private void copyFilesToBuildDirectory(List<SloccountPublisherReport.SlaveFile> sourceFiles, File rootDir, VirtualChannel channel) throws IOException, InterruptedException {
        File destDir = new File(rootDir, BUILD_SUBDIR);
        if (!destDir.exists() && !destDir.mkdir()) {
            throw new IOException("Creating directory for copy of workspace files failed: " + destDir.getAbsolutePath());
        }
        for (SloccountPublisherReport.SlaveFile sourceFile : sourceFiles) {
            File masterFile = new File(destDir, Integer.toHexString(sourceFile.hashCode()) + "_" + sourceFile.getName());
            if (masterFile.exists()) continue;
            FileOutputStream outputStream = new FileOutputStream(masterFile);
            new FilePath(channel, sourceFile.getAbsolutePath()).copyTo((OutputStream)outputStream);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getRealEncoding() {
        if (this.getEncoding() == null || this.getEncoding().length() == 0) {
            return DEFAULT_ENCODING;
        }
        return this.getEncoding();
    }

    private String getRealPattern() {
        if (this.getPattern() == null || this.getPattern().length() == 0) {
            return DEFAULT_PATTERN;
        }
        return this.getPattern();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getNumBuildsInGraph() {
        return this.numBuildsInGraph;
    }

    public boolean isIgnoreBuildFailure() {
        return this.ignoreBuildFailure;
    }

    public boolean isCommentIsCode() {
        return this.commentIsCode;
    }
}

