/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount;

import hudson.model.Api;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.sloccount.model.File;
import hudson.plugins.sloccount.model.FileFilter;
import hudson.plugins.sloccount.model.Language;
import hudson.plugins.sloccount.model.SloccountLanguageStatistics;
import hudson.plugins.sloccount.model.SloccountParser;
import hudson.plugins.sloccount.model.SloccountReport;
import hudson.plugins.sloccount.model.SloccountReportStatistics;
import java.io.Serializable;
import java.util.ArrayList;

public class SloccountResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient SloccountReport report;
    private transient Run<?, ?> owner;
    private SloccountReportStatistics statistics;
    private final String encoding;
    private final boolean commentIsCode;

    public SloccountResult(SloccountReportStatistics statistics, String encoding, boolean commentIsCode, SloccountReport report, Run<?, ?> owner) {
        this.statistics = statistics;
        this.encoding = encoding;
        this.commentIsCode = commentIsCode;
        this.report = report;
        this.owner = owner;
    }

    public SloccountReport getReport() {
        return this.lazyLoadReport();
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Run<?, ?> o) {
        this.owner = o;
    }

    public SloccountReportStatistics getStatistics() {
        return this.statistics;
    }

    protected Object readResolve() {
        if (this.report != null && this.statistics == null) {
            ArrayList<SloccountLanguageStatistics> languages = new ArrayList<SloccountLanguageStatistics>();
            for (Language language : this.report.getLanguages()) {
                languages.add(new SloccountLanguageStatistics(language.getName(), language.getLineCount(), language.getFileCount(), language.getCommentCount()));
            }
            this.statistics = new SloccountReportStatistics(languages);
        }
        if (this.statistics == null) {
            this.statistics = new SloccountReportStatistics(new ArrayList<SloccountLanguageStatistics>());
        }
        return this;
    }

    private SloccountReport lazyLoadReport() {
        if (this.report != null) {
            return this.report;
        }
        java.io.File destDir = new java.io.File(this.owner.getRootDir(), "sloccount-plugin");
        if (!destDir.exists()) {
            return new SloccountReport();
        }
        String realEncoding = this.encoding != null && !this.encoding.isEmpty() ? this.encoding : "UTF-8";
        SloccountParser parser = new SloccountParser(realEncoding, null, null, this.commentIsCode);
        java.io.File[] files = destDir.listFiles();
        if (files != null) {
            return parser.parseFiles(files);
        }
        return null;
    }

    public boolean isEmpty() {
        if (this.statistics != null) {
            return this.statistics.getLineCount() <= 0;
        }
        if (this.report != null) {
            return this.report.getLineCount() <= 0;
        }
        return true;
    }

    public SloccountResult getLanguageResult(String language) {
        SloccountReport filtered = new SloccountReport(this.getReport(), new LanguageFileFilter(language));
        return new BreadCrumbResult(filtered, this.owner, language, this.commentIsCode);
    }

    public SloccountResult getModuleResult(String module) {
        SloccountReport filtered = new SloccountReport(this.getReport(), new ModuleFileFilter(module));
        return new BreadCrumbResult(filtered, this.owner, module, this.commentIsCode);
    }

    public SloccountResult getFolderResult(String folder) {
        SloccountReport filtered = new SloccountReport(this.getReport(), new FolderFileFilter(folder));
        return new BreadCrumbResult(filtered, this.owner, folder, this.commentIsCode);
    }

    public Api getApi() {
        return new Api((Object)this.getStatistics());
    }

    private static class BreadCrumbResult
    extends SloccountResult
    implements ModelObject {
        private static final long serialVersionUID = 0L;
        private String displayName = null;

        public BreadCrumbResult(SloccountReport report, Run<?, ?> owner, String displayName, boolean commentIsCode) {
            super(null, null, commentIsCode, report, owner);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static class FolderFileFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = 0L;
        private String folder;

        public FolderFileFilter(String folder) {
            this.folder = folder;
        }

        @Override
        public boolean include(File file) {
            String fileFolder = SloccountReport.extractFolder(file.getName());
            return this.folder.equals(fileFolder);
        }
    }

    private static class ModuleFileFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = 0L;
        private String module;

        public ModuleFileFilter(String module) {
            this.module = module;
        }

        @Override
        public boolean include(File file) {
            return file.getModule().equals(this.module);
        }
    }

    private static class LanguageFileFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = 0L;
        private String language;

        public LanguageFileFilter(String language) {
            this.language = language;
        }

        @Override
        public boolean include(File file) {
            return file.getLanguage().equals(this.language);
        }
    }
}

