/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.dashboard;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.sloccount.Messages;
import hudson.plugins.sloccount.SloccountBuildAction;
import hudson.plugins.sloccount.SloccountResult;
import hudson.plugins.sloccount.model.SloccountLanguageStatistics;
import hudson.plugins.sloccount.model.SloccountReportStatistics;
import hudson.plugins.sloccount.util.StringUtil;
import hudson.plugins.view.dashboard.DashboardPortlet;
import java.util.LinkedList;
import org.kohsuke.stapler.DataBoundConstructor;

public class SloccountTablePortlet
extends DashboardPortlet {
    @DataBoundConstructor
    public SloccountTablePortlet(String name) {
        super(name);
    }

    public SloccountReportStatistics getStatistics(Job<?, ?> job) {
        for (Run build = job.getLastBuild(); build != null; build = build.getPreviousBuild()) {
            SloccountResult result;
            SloccountBuildAction action = (SloccountBuildAction)build.getAction(SloccountBuildAction.class);
            if (action == null || (result = action.getResult()) == null || result.isEmpty()) continue;
            return result.getStatistics();
        }
        return new SloccountReportStatistics(new LinkedList<SloccountLanguageStatistics>());
    }

    public String grouping(int value) {
        return StringUtil.grouping(value);
    }

    @Extension(optional=true)
    public static class SloccountTableDescriptor
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Sloccount_Portlet_Name();
        }
    }
}

