/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.model;

import hudson.plugins.sloccount.model.Countable;
import hudson.plugins.sloccount.util.StringUtil;
import java.io.Serializable;

public class File
implements Countable,
Serializable {
    private static final long serialVersionUID = 0L;
    private String name;
    private final String language;
    private final String module;
    private final int lineCount;
    private final int commentCount;

    public File(String name, String language, String module, int lineCount, int commentCount) {
        this.name = name;
        this.language = language;
        this.module = module;
        this.lineCount = lineCount;
        this.commentCount = commentCount;
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public String getLineCountString() {
        return StringUtil.grouping(this.getLineCount());
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public String getCommentCountString() {
        return StringUtil.grouping(this.getCommentCount());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getModule() {
        return this.module;
    }

    public void simplifyName(String rootPath) {
        this.name = this.name.substring(rootPath.length());
    }
}

