/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.model;

import hudson.plugins.sloccount.model.Countable;
import hudson.plugins.sloccount.model.File;
import hudson.plugins.sloccount.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class FileContainer
implements Countable,
Serializable {
    private static final long serialVersionUID = 0L;
    private Map<String, File> files = new LinkedHashMap<String, File>();
    private int lineCount = 0;
    private int commentCount = 0;

    public File getFile(String name) {
        return this.files.get(name);
    }

    public List<File> getFiles() {
        return new ArrayList<File>(this.files.values());
    }

    public int getFileCount() {
        return this.files.size();
    }

    public String getFileCountString() {
        return StringUtil.grouping(this.getFileCount());
    }

    public void addFile(File file) {
        this.files.put(file.getName(), file);
        this.lineCount += file.getLineCount();
        this.commentCount += file.getCommentCount();
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public String getLineCountString() {
        return StringUtil.grouping(this.getLineCount());
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public String getCommentCountString() {
        return StringUtil.grouping(this.getCommentCount());
    }
}

