/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.model;

import hudson.plugins.sloccount.model.SloccountPublisherReport;
import hudson.plugins.sloccount.model.SloccountReport;
import hudson.plugins.sloccount.model.SloccountReportInterface;
import hudson.plugins.sloccount.model.cloc.ClocReport;
import hudson.plugins.sloccount.util.FileFinder;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import javax.xml.bind.JAXBException;
import jenkins.MasterToSlaveFileCallable;

public class SloccountParser
extends MasterToSlaveFileCallable<SloccountPublisherReport> {
    private static final long serialVersionUID = 1L;
    private static final boolean LOG_ENABLED = false;
    private final String encoding;
    private final String filePattern;
    private transient PrintStream logger = null;
    private final boolean commentIsCode;

    public SloccountParser(String encoding, String filePattern, PrintStream logger, boolean commentIsCode) {
        this.logger = logger;
        this.filePattern = filePattern;
        this.encoding = encoding;
        this.commentIsCode = commentIsCode;
    }

    public SloccountPublisherReport invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] found;
        SloccountPublisherReport report = new SloccountPublisherReport();
        FileFinder finder = new FileFinder(this.filePattern);
        for (String fileName : found = finder.find(workspace)) {
            this.parse(new File(workspace, fileName), (SloccountReportInterface)report);
            report.addSourceFile(new File(workspace, fileName));
        }
        return report;
    }

    public SloccountReport parseFiles(File[] files) {
        SloccountReport report = new SloccountReport();
        for (File file : files) {
            try {
                this.parse(file, (SloccountReportInterface)report);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        report.simplifyNames();
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File file, SloccountReportInterface report) throws IOException {
        try {
            ClocReport.parse(file).toSloccountReport(report, this.commentIsCode);
        }
        catch (JAXBException e) {
            try (InputStreamReader in = null;){
                in = new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
                this.parse(in, report);
            }
        }
    }

    private void parse(Reader reader, SloccountReportInterface report) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            this.parseLine(line, report);
        }
    }

    private void parseLine(String line, SloccountReportInterface report) {
        String[] tokens = line.split("\t");
        if (tokens.length != 4) {
            return;
        }
        int lineCount = Integer.parseInt(tokens[0]);
        String languageName = tokens[1];
        String moduleName = tokens[2];
        String filePath = tokens[3];
        report.add(filePath, languageName, moduleName, lineCount, 0);
    }
}

