/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.model;

import hudson.plugins.sloccount.model.SloccountLanguageStatistics;
import hudson.plugins.sloccount.model.SloccountReportInterface;
import hudson.plugins.sloccount.model.SloccountReportStatistics;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SloccountPublisherReport
implements Serializable,
SloccountReportInterface {
    private static final long serialVersionUID = 1L;
    private final Map<String, LanguageStatistics> statistics = new HashMap<String, LanguageStatistics>();
    private final List<SlaveFile> sourceFiles = new LinkedList<SlaveFile>();

    public SloccountReportStatistics getStatistics() {
        LinkedList<SloccountLanguageStatistics> ret = new LinkedList<SloccountLanguageStatistics>();
        for (Map.Entry<String, LanguageStatistics> it : this.statistics.entrySet()) {
            ret.add(new SloccountLanguageStatistics(it.getKey(), it.getValue().numLines, it.getValue().numFiles, it.getValue().numComments));
        }
        return new SloccountReportStatistics(ret);
    }

    public List<SlaveFile> getSourceFiles() {
        return Collections.unmodifiableList(this.sourceFiles);
    }

    public void addSourceFile(File sourceFile) {
        this.sourceFiles.add(new SlaveFile(sourceFile));
    }

    @Override
    public void add(String filePath, String languageName, String moduleName, int lineCount, int commentCount) {
        LanguageStatistics stat = this.statistics.get(languageName);
        if (stat == null) {
            stat = new LanguageStatistics();
            this.statistics.put(languageName, stat);
        }
        stat.numLines += lineCount;
        stat.numComments += commentCount;
        ++stat.numFiles;
    }

    @Override
    public String getRootFolder() {
        return "";
    }

    public static class SlaveFile
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String name;
        private final String absolutePath;

        public SlaveFile(File file) {
            this.name = file.getName();
            this.absolutePath = file.getAbsolutePath();
        }

        public String getName() {
            return this.name;
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }
    }

    public static class LanguageStatistics
    implements Serializable {
        private static final long serialVersionUID = 0L;
        int numLines = 0;
        int numFiles = 0;
        int numComments = 0;
    }
}

