/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.model;

import hudson.plugins.sloccount.model.File;
import hudson.plugins.sloccount.model.FileContainer;
import hudson.plugins.sloccount.model.FileFilter;
import hudson.plugins.sloccount.model.Folder;
import hudson.plugins.sloccount.model.Language;
import hudson.plugins.sloccount.model.Module;
import hudson.plugins.sloccount.model.SloccountReportInterface;
import hudson.plugins.sloccount.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SloccountReport
extends FileContainer
implements SloccountReportInterface {
    private static final long serialVersionUID = 0L;
    public static final String DIRECTORY_SEPARATOR = "/";
    private Map<String, Folder> folders = new LinkedHashMap<String, Folder>();
    private Map<String, Language> languages = new LinkedHashMap<String, Language>();
    private Map<String, Module> modules = new LinkedHashMap<String, Module>();
    private String[] rootFolderPath = null;

    public SloccountReport() {
    }

    public SloccountReport(SloccountReport old, FileFilter filter) {
        this();
        for (File f : old.getFiles()) {
            if (!filter.include(f)) continue;
            this.add(f.getName(), f.getLanguage(), f.getModule(), f.getLineCount(), f.getCommentCount());
        }
    }

    @Override
    public void add(String filePath, String languageName, String moduleName, int lineCount, int commentCount) {
        filePath = filePath.replace("\\", DIRECTORY_SEPARATOR);
        String folderPath = SloccountReport.extractFolder(filePath);
        File file = new File(filePath, languageName, moduleName, lineCount, commentCount);
        this.addFile(file);
        Folder folder = this.getFolder(folderPath);
        if (folder == null) {
            folder = new Folder(folderPath);
            this.addFolder(folder);
        }
        folder.addFile(file);
        Language language = this.getLanguage(languageName);
        if (language == null) {
            language = new Language(languageName);
            this.addLanguage(language);
        }
        language.addFile(file);
        Module module = this.getModule(moduleName);
        if (module == null) {
            module = new Module(moduleName);
            this.addModule(module);
        }
        module.addFile(file);
    }

    public static String extractFolder(String filePath) {
        int index = filePath.lastIndexOf(DIRECTORY_SEPARATOR);
        if (index != -1) {
            return filePath.substring(0, index + 1);
        }
        return "";
    }

    public Folder getFolder(String name) {
        return this.folders.get(name);
    }

    public List<Folder> getFolders() {
        return new ArrayList<Folder>(this.folders.values());
    }

    public int getFolderCount() {
        return this.folders.size();
    }

    public String getFolderCountString() {
        return StringUtil.grouping(this.folders.size());
    }

    public Language getLanguage(String name) {
        return this.languages.get(name);
    }

    public List<Language> getLanguages() {
        return new ArrayList<Language>(this.languages.values());
    }

    public int getLanguageCount() {
        return this.languages.size();
    }

    public String getLanguageCountString() {
        return StringUtil.grouping(this.getLanguageCount());
    }

    public Module getModule(String name) {
        return this.modules.get(name);
    }

    public List<Module> getModules() {
        return new ArrayList<Module>(this.modules.values());
    }

    public int getModuleCount() {
        if (this.modules == null) {
            return 0;
        }
        return this.modules.size();
    }

    public String getModuleCountString() {
        return StringUtil.grouping(this.getModuleCount());
    }

    public void addFolder(Folder folder) {
        this.folders.put(folder.getName(), folder);
        this.updateRootFolderPath(folder.getName());
    }

    public void addLanguage(Language language) {
        this.languages.put(language.getName(), language);
    }

    public void addModule(Module module) {
        this.modules.put(module.getName(), module);
    }

    @Override
    public String getRootFolder() {
        if (this.rootFolderPath == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.rootFolderPath.length; ++i) {
            if (i > 0) {
                builder.append(DIRECTORY_SEPARATOR);
            }
            builder.append(this.rootFolderPath[i]);
        }
        return builder.toString();
    }

    private void updateRootFolderPath(String newFolderName) {
        String[] newFolderPath = newFolderName.split(DIRECTORY_SEPARATOR);
        if (this.rootFolderPath == null) {
            this.rootFolderPath = newFolderPath;
        } else {
            for (int i = 0; i < this.rootFolderPath.length && i < newFolderPath.length; ++i) {
                if (this.rootFolderPath[i].equals(newFolderPath[i])) continue;
                String[] newRoot = new String[i];
                System.arraycopy(this.rootFolderPath, 0, newRoot, 0, i);
                this.rootFolderPath = newRoot;
                return;
            }
            if (newFolderPath.length < this.rootFolderPath.length) {
                this.rootFolderPath = newFolderPath;
            }
        }
    }

    public File getLongestFile() {
        File longest = null;
        for (File f : this.getFiles()) {
            if (longest != null && f.getLineCount() <= longest.getLineCount()) continue;
            longest = f;
        }
        return longest;
    }

    public Folder getLongestFolder() {
        Folder longest = null;
        for (Folder f : this.getFolders()) {
            if (longest != null && f.getLineCount() <= longest.getLineCount()) continue;
            longest = f;
        }
        return longest;
    }

    public Language getLongestLanguage() {
        Language longest = null;
        for (Language l : this.getLanguages()) {
            if (longest != null && l.getLineCount() <= longest.getLineCount()) continue;
            longest = l;
        }
        return longest;
    }

    public Module getLongestModule() {
        Module longest = null;
        for (Module module : this.getModules()) {
            if (longest != null && module.getLineCount() <= longest.getLineCount()) continue;
            longest = module;
        }
        return longest;
    }

    public void simplifyNames() {
        String root = this.getRootFolder();
        for (File file : this.getFiles()) {
            file.simplifyName(root);
        }
        for (Folder folder : this.getFolders()) {
            folder.simplifyName(root);
        }
    }

    @Override
    public String getName() {
        return "SlocCount Report";
    }
}

