/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.model;

import hudson.plugins.sloccount.model.SloccountLanguageStatistics;
import hudson.plugins.sloccount.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SloccountReportStatistics
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<SloccountLanguageStatistics> statistics;

    public SloccountReportStatistics(List<SloccountLanguageStatistics> statistics) {
        this.statistics = new ArrayList<SloccountLanguageStatistics>(statistics);
    }

    @Exported(name="languages")
    public List<SloccountLanguageStatistics> getStatistics() {
        return Collections.unmodifiableList(this.statistics);
    }

    @Exported(name="totalLines")
    public int getLineCount() {
        int lineCount = 0;
        for (SloccountLanguageStatistics it : this.statistics) {
            lineCount += it.getLineCount();
        }
        return lineCount;
    }

    @Exported(name="totalFiles")
    public int getFileCount() {
        int fileCount = 0;
        for (SloccountLanguageStatistics it : this.statistics) {
            fileCount += it.getFileCount();
        }
        return fileCount;
    }

    @Exported(name="totalLanguages")
    public int getLanguageCount() {
        return this.statistics.size();
    }

    @Exported(name="totalComments")
    public int getCommentCount() {
        int commentCount = 0;
        for (SloccountLanguageStatistics it : this.statistics) {
            commentCount += it.getCommentCount();
        }
        return commentCount;
    }

    public String getLineCountString() {
        return StringUtil.grouping(this.getLineCount());
    }

    public String getFileCountString() {
        return StringUtil.grouping(this.getFileCount());
    }

    public String getCommentCountString() {
        return StringUtil.grouping(this.getCommentCount());
    }

    public String getLanguageCountString() {
        return StringUtil.grouping(this.getLanguageCount());
    }

    public SloccountLanguageStatistics getLanguage(String name) {
        for (SloccountLanguageStatistics it : this.statistics) {
            if (!it.getName().equals(name)) continue;
            return it;
        }
        return new SloccountLanguageStatistics(name, 0, 0, 0);
    }

    public List<String> getAllLanguages() {
        LinkedList<String> languages = new LinkedList<String>();
        for (SloccountLanguageStatistics it : this.statistics) {
            languages.add(it.getName());
        }
        return languages;
    }
}

