/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sloccount.model.cloc;

import hudson.plugins.sloccount.model.SloccountReportInterface;
import hudson.plugins.sloccount.model.cloc.ClocFile;
import hudson.plugins.sloccount.model.cloc.ClocFiles;
import hudson.plugins.sloccount.model.cloc.ClocHeader;
import java.io.File;
import java.io.Serializable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="results")
public class ClocReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="header", type=ClocHeader.class)
    private final ClocHeader header;
    @XmlElement(name="files", type=ClocFiles.class)
    private final ClocFiles files;

    public ClocReport(ClocHeader header, ClocFiles files) {
        this.header = header;
        this.files = files;
    }

    public ClocReport() {
        this(null, null);
    }

    public ClocHeader getHeader() {
        return this.header;
    }

    public ClocFiles getFiles() {
        return this.files;
    }

    public static ClocReport parse(File file) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ClocReport.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (ClocReport)unmarshaller.unmarshal(file);
    }

    public void toSloccountReport(SloccountReportInterface report, boolean commentIsCode) throws JAXBException {
        try {
            for (ClocFile file : this.files.getFiles()) {
                String filePath = file.getName().replace('\\', '/');
                int begin = filePath.indexOf(47);
                int end = filePath.indexOf(47, begin + 1);
                String moduleName = begin != -1 && end != -1 ? filePath.substring(begin + 1, end) : "";
                int lineCount = file.getCode();
                if (commentIsCode) {
                    lineCount += file.getComment();
                }
                report.add(filePath, file.getLanguage(), moduleName, lineCount, file.getComment());
            }
        }
        catch (RuntimeException e) {
            throw new JAXBException("Broken cloc report file: " + e, (Throwable)e);
        }
    }
}

