/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.sloccount.steps;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sloccount.SloccountPublisher;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SloccountPublisherStep
extends Step
implements Serializable {
    private String pattern = "";
    private String encoding = "";
    private boolean commentIsCode = true;
    private int numBuildsInGraph = 100;
    private boolean ignoreBuildFailure = false;

    @DataBoundConstructor
    public SloccountPublisherStep(String pattern, String encoding, boolean commentIsCode, int numBuildsInGraph, boolean ignoreBuildFailure) {
        this.pattern = pattern;
        this.encoding = encoding;
        this.commentIsCode = commentIsCode;
        this.numBuildsInGraph = numBuildsInGraph;
        this.ignoreBuildFailure = ignoreBuildFailure;
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern == null ? null : pattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = encoding == null ? null : encoding;
    }

    public boolean getCommentIsCode() {
        return this.commentIsCode;
    }

    @DataBoundSetter
    public void setCommentIsCode(boolean commentIsCode) {
        this.commentIsCode = commentIsCode;
    }

    public int getNumBuildsInGraph() {
        return this.numBuildsInGraph;
    }

    @DataBoundSetter
    public void setNumBuildsInGraph(int numBuildsInGraph) {
        this.numBuildsInGraph = numBuildsInGraph;
    }

    public boolean getIgnoreBuildFailure() {
        return this.ignoreBuildFailure;
    }

    @DataBoundSetter
    public void setIgnoreBuildFailure(boolean ignoreBuildFailure) {
        this.ignoreBuildFailure = ignoreBuildFailure;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SloccountPublisherStepExecution(this, context);
    }

    private static final class SloccountPublisherStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient SloccountPublisherStep step;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient Run<?, ?> run;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient TaskListener listener;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient FilePath ws;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient Launcher launcher;

        SloccountPublisherStepExecution(SloccountPublisherStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
            this.listener = (TaskListener)context.get(TaskListener.class);
            this.run = (Run)context.get(Run.class);
            this.ws = (FilePath)context.get(FilePath.class);
            this.launcher = (Launcher)context.get(Launcher.class);
        }

        protected Void run() throws Exception {
            this.listener.getLogger().println("Running Sloccount Publisher step");
            SloccountPublisher publisher = new SloccountPublisher(this.step.getPattern(), this.step.getEncoding(), this.step.getCommentIsCode(), this.step.getNumBuildsInGraph(), this.step.getIgnoreBuildFailure());
            publisher.perform(this.run, this.ws, this.launcher, this.listener);
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "sloccountPublish";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Run.class, Launcher.class, TaskListener.class);
        }

        @Nonnull
        public String getDisplayName() {
            return "Publish Sloccount reports";
        }
    }
}

