/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SkipFromToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
@BridgeMethodsAdded
public abstract class GHObject {
    protected Map<String, List<String>> responseHeaderFields;
    protected String url;
    protected long id;
    protected String created_at;
    protected String updated_at;
    private static final ToStringStyle TOSTRING_STYLE = new ToStringStyle(){
        {
            this.setUseShortClassName(true);
        }

        public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
            if (fieldName.contains("_")) {
                return;
            }
            if (value instanceof GHObject) {
                return;
            }
            if (value instanceof GitHub) {
                return;
            }
            super.append(buffer, fieldName, value, fullDetail);
        }
    };

    GHObject() {
    }

    @CheckForNull
    @Deprecated
    public Map<String, List<String>> getResponseHeaderFields() {
        return this.responseHeaderFields;
    }

    @WithBridgeMethods(value={String.class}, adapterMethod="createdAtStr")
    public Date getCreatedAt() throws IOException {
        return GitHub.parseDate(this.created_at);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Bridge method of getCreatedAt")
    private Object createdAtStr(Date id, Class type) {
        return this.created_at;
    }

    @WithBridgeMethods(value={String.class}, adapterMethod="urlToString")
    public URL getUrl() {
        return GitHub.parseURL(this.url);
    }

    @WithBridgeMethods(value={String.class}, adapterMethod="urlToString")
    public abstract URL getHtmlUrl() throws IOException;

    public Date getUpdatedAt() throws IOException {
        return GitHub.parseDate(this.updated_at);
    }

    @WithBridgeMethods(value={String.class, int.class}, adapterMethod="longToStringOrInt")
    public long getId() {
        return this.id;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Bridge method of getId")
    private Object longToStringOrInt(long id, Class type) {
        if (type == String.class) {
            return String.valueOf(id);
        }
        if (type == Integer.TYPE) {
            return (int)id;
        }
        throw new AssertionError((Object)("Unexpected type: " + type));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Bridge method of getHtmlUrl")
    private Object urlToString(URL url, Class type) {
        return url == null ? null : url.toString();
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, TOSTRING_STYLE, null, null, false, false){

            protected boolean accept(Field field) {
                return super.accept(field) && !field.isAnnotationPresent(SkipFromToString.class);
            }
        }.toString();
    }
}

