/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHAuthorization;
import org.kohsuke.github.GHCommitSearchBuilder;
import org.kohsuke.github.GHContentSearchBuilder;
import org.kohsuke.github.GHCreateRepositoryBuilder;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GHGistBuilder;
import org.kohsuke.github.GHIssueSearchBuilder;
import org.kohsuke.github.GHLicense;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHNotificationStream;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositorySearchBuilder;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHUserSearchBuilder;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.JsonRateLimit;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Preview;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GitHub {
    final String login;
    final String encodedAuthorization;
    private final ConcurrentMap<String, GHUser> users;
    private final ConcurrentMap<String, GHOrganization> orgs;
    private GHMyself myself;
    private final String apiUrl;
    final RateLimitHandler rateLimitHandler;
    final AbuseLimitHandler abuseLimitHandler;
    private HttpConnector connector = HttpConnector.DEFAULT;
    private final Object headerRateLimitLock = new Object();
    private GHRateLimit headerRateLimit = null;
    private volatile GHRateLimit rateLimit = null;
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String[] TIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'"};
    static final String GITHUB_URL = "https://api.github.com";
    private static final Logger LOGGER;

    GitHub(String apiUrl, String login, String oauthAccessToken, String password, HttpConnector connector, RateLimitHandler rateLimitHandler, AbuseLimitHandler abuseLimitHandler) throws IOException {
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length() - 1);
        }
        this.apiUrl = apiUrl;
        if (null != connector) {
            this.connector = connector;
        }
        if (oauthAccessToken != null) {
            this.encodedAuthorization = "token " + oauthAccessToken;
        } else if (password != null) {
            String authorization = login + ':' + password;
            String charsetName = Charsets.UTF_8.name();
            this.encodedAuthorization = "Basic " + new String(Base64.encodeBase64((byte[])authorization.getBytes(charsetName)), charsetName);
        } else {
            this.encodedAuthorization = null;
        }
        this.users = new ConcurrentHashMap<String, GHUser>();
        this.orgs = new ConcurrentHashMap<String, GHOrganization>();
        this.rateLimitHandler = rateLimitHandler;
        this.abuseLimitHandler = abuseLimitHandler;
        if (login == null && this.encodedAuthorization != null) {
            login = this.getMyself().getLogin();
        }
        this.login = login;
    }

    public static GitHub connect() throws IOException {
        return GitHubBuilder.fromCredentials().build();
    }

    public static GitHub connectToEnterprise(String apiUrl, String oauthAccessToken) throws IOException {
        return GitHub.connectToEnterpriseWithOAuth(apiUrl, null, oauthAccessToken);
    }

    public static GitHub connectToEnterpriseWithOAuth(String apiUrl, String login, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).withOAuthToken(oauthAccessToken, login).build();
    }

    public static GitHub connectToEnterprise(String apiUrl, String login, String password) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).withPassword(login, password).build();
    }

    public static GitHub connect(String login, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken, login).build();
    }

    public static GitHub connect(String login, String oauthAccessToken, String password) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken, login).withPassword(login, password).build();
    }

    public static GitHub connectUsingPassword(String login, String password) throws IOException {
        return new GitHubBuilder().withPassword(login, password).build();
    }

    public static GitHub connectUsingOAuth(String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken).build();
    }

    public static GitHub connectUsingOAuth(String githubServer, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withEndpoint(githubServer).withOAuthToken(oauthAccessToken).build();
    }

    public static GitHub connectAnonymously() throws IOException {
        return new GitHubBuilder().build();
    }

    public static GitHub connectToEnterpriseAnonymously(String apiUrl) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).build();
    }

    public static GitHub offline() {
        try {
            return new GitHubBuilder().withEndpoint("https://api.github.invalid").withConnector(HttpConnector.OFFLINE).build();
        }
        catch (IOException e) {
            throw new IllegalStateException("The offline implementation constructor should not connect", e);
        }
    }

    public boolean isAnonymous() {
        return this.login == null && this.encodedAuthorization == null;
    }

    public boolean isOffline() {
        return this.connector == HttpConnector.OFFLINE;
    }

    public HttpConnector getConnector() {
        return this.connector;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setConnector(HttpConnector connector) {
        this.connector = connector;
    }

    void requireCredential() {
        if (this.isAnonymous()) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    URL getApiURL(String tailApiUrl) throws IOException {
        if (tailApiUrl.startsWith("/")) {
            if ("github.com".equals(this.apiUrl)) {
                return new URL(GITHUB_URL + tailApiUrl);
            }
            return new URL(this.apiUrl + tailApiUrl);
        }
        return new URL(tailApiUrl);
    }

    Requester retrieve() {
        return new Requester(this).method("GET");
    }

    public GHRateLimit getRateLimit() throws IOException {
        try {
            this.rateLimit = ((JsonRateLimit)((Object)this.retrieve().to((String)"/rate_limit", JsonRateLimit.class))).rate;
            return this.rateLimit;
        }
        catch (FileNotFoundException e) {
            GHRateLimit r = new GHRateLimit();
            r.remaining = 1000000;
            r.limit = 1000000;
            long hour = 3600L;
            r.reset = new Date(System.currentTimeMillis() / 1000L + hour);
            this.rateLimit = r;
            return this.rateLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRateLimit(@Nonnull GHRateLimit observed) {
        Object object = this.headerRateLimitLock;
        synchronized (object) {
            if (this.headerRateLimit == null || this.headerRateLimit.getResetDate().getTime() < observed.getResetDate().getTime() || this.headerRateLimit.remaining > observed.remaining) {
                this.headerRateLimit = observed;
                LOGGER.log(Level.FINE, "Rate limit now: {0}", this.headerRateLimit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public GHRateLimit lastRateLimit() {
        Object object = this.headerRateLimitLock;
        synchronized (object) {
            return this.headerRateLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public GHRateLimit rateLimit() throws IOException {
        Object object = this.headerRateLimitLock;
        synchronized (object) {
            if (this.headerRateLimit != null) {
                return this.headerRateLimit;
            }
        }
        GHRateLimit rateLimit = this.rateLimit;
        if (rateLimit == null || rateLimit.getResetDate().getTime() < System.currentTimeMillis()) {
            rateLimit = this.getRateLimit();
        }
        return rateLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WithBridgeMethods(value={GHUser.class})
    public GHMyself getMyself() throws IOException {
        this.requireCredential();
        GitHub gitHub = this;
        synchronized (gitHub) {
            if (this.myself != null) {
                return this.myself;
            }
            GHMyself u = (GHMyself)((Object)this.retrieve().to("/user", GHMyself.class));
            u.root = this;
            this.myself = u;
            return u;
        }
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = (GHUser)this.users.get(login);
        if (u == null) {
            u = (GHUser)((Object)this.retrieve().to("/users/" + login, GHUser.class));
            u.root = this;
            this.users.put(u.getLogin(), u);
        }
        return u;
    }

    public void refreshCache() {
        this.users.clear();
        this.orgs.clear();
    }

    protected GHUser getUser(GHUser orig) {
        GHUser u = (GHUser)this.users.get(orig.getLogin());
        if (u == null) {
            orig.root = this;
            this.users.put(orig.getLogin(), orig);
            return orig;
        }
        return u;
    }

    public GHOrganization getOrganization(String name) throws IOException {
        GHOrganization o = (GHOrganization)this.orgs.get(name);
        if (o == null) {
            o = ((GHOrganization)((Object)this.retrieve().to("/orgs/" + name, GHOrganization.class))).wrapUp(this);
            this.orgs.put(name, o);
        }
        return o;
    }

    public PagedIterable<GHOrganization> listOrganizations() {
        return this.listOrganizations(null);
    }

    public PagedIterable<GHOrganization> listOrganizations(final String since) {
        return new PagedIterable<GHOrganization>(){

            @Override
            public PagedIterator<GHOrganization> _iterator(int pageSize) {
                System.out.println("page size: " + pageSize);
                return new PagedIterator<GHOrganization>(GitHub.this.retrieve().with("since", since).asIterator("/organizations", GHOrganization[].class, pageSize)){

                    protected void wrapUp(GHOrganization[] page) {
                        for (GHOrganization c : page) {
                            c.wrapUp(GitHub.this);
                        }
                    }
                };
            }
        };
    }

    public GHRepository getRepository(String name) throws IOException {
        String[] tokens = name.split("/");
        return ((GHRepository)((Object)this.retrieve().to("/repos/" + tokens[0] + '/' + tokens[1], GHRepository.class))).wrap(this);
    }

    @Preview
    @Deprecated
    public PagedIterable<GHLicense> listLicenses() throws IOException {
        return new PagedIterable<GHLicense>(){

            @Override
            public PagedIterator<GHLicense> _iterator(int pageSize) {
                return new PagedIterator<GHLicense>(GitHub.this.retrieve().withPreview("application/vnd.github.drax-preview+json").asIterator("/licenses", GHLicense[].class, pageSize)){

                    protected void wrapUp(GHLicense[] page) {
                        for (GHLicense c : page) {
                            c.wrap(GitHub.this);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHUser> listUsers() throws IOException {
        return new PagedIterable<GHUser>(){

            @Override
            public PagedIterator<GHUser> _iterator(int pageSize) {
                return new PagedIterator<GHUser>(GitHub.this.retrieve().asIterator("/users", GHUser[].class, pageSize)){

                    protected void wrapUp(GHUser[] page) {
                        for (GHUser u : page) {
                            u.wrapUp(GitHub.this);
                        }
                    }
                };
            }
        };
    }

    @Preview
    @Deprecated
    public GHLicense getLicense(String key) throws IOException {
        return (GHLicense)((Object)this.retrieve().withPreview("application/vnd.github.drax-preview+json").to("/licenses/" + key, GHLicense.class));
    }

    public Map<String, GHOrganization> getMyOrganizations() throws IOException {
        GHOrganization[] orgs = (GHOrganization[])this.retrieve().to("/user/orgs", GHOrganization[].class);
        HashMap<String, GHOrganization> r = new HashMap<String, GHOrganization>();
        for (GHOrganization o : orgs) {
            r.put(o.getLogin(), o.wrapUp(this));
        }
        return r;
    }

    public Map<String, Set<GHTeam>> getMyTeams() throws IOException {
        HashMap<String, Set<GHTeam>> allMyTeams = new HashMap<String, Set<GHTeam>>();
        for (GHTeam team : (GHTeam[])this.retrieve().to("/user/teams", GHTeam[].class)) {
            team.wrapUp(this);
            String orgLogin = team.getOrganization().getLogin();
            HashSet<GHTeam> teamsPerOrg = (HashSet<GHTeam>)allMyTeams.get(orgLogin);
            if (teamsPerOrg == null) {
                teamsPerOrg = new HashSet<GHTeam>();
            }
            teamsPerOrg.add(team);
            allMyTeams.put(orgLogin, teamsPerOrg);
        }
        return allMyTeams;
    }

    public List<GHEventInfo> getEvents() throws IOException {
        GHEventInfo[] events;
        for (GHEventInfo e : events = (GHEventInfo[])this.retrieve().to("/events", GHEventInfo[].class)) {
            e.wrapUp(this);
        }
        return Arrays.asList(events);
    }

    public GHGist getGist(String id) throws IOException {
        return ((GHGist)((Object)this.retrieve().to("/gists/" + id, GHGist.class))).wrapUp(this);
    }

    public GHGistBuilder createGist() {
        return new GHGistBuilder(this);
    }

    public <T extends GHEventPayload> T parseEventPayload(Reader r, Class<T> type) throws IOException {
        GHEventPayload t = (GHEventPayload)MAPPER.readValue(r, type);
        t.wrapUp(this);
        return (T)t;
    }

    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        return this.createRepository(name).description(description).homepage(homepage).private_(!isPublic).create();
    }

    public GHCreateRepositoryBuilder createRepository(String name) {
        return new GHCreateRepositoryBuilder(this, "/user/repos", name);
    }

    public GHAuthorization createToken(Collection<String> scope, String note, String noteUrl) throws IOException {
        Requester requester = new Requester(this).with("scopes", scope).with("note", note).with("note_url", noteUrl);
        return ((GHAuthorization)((Object)requester.method("POST").to("/authorizations", GHAuthorization.class))).wrap(this);
    }

    public GHAuthorization createOrGetAuth(String clientId, String clientSecret, List<String> scopes, String note, String note_url) throws IOException {
        Requester requester = new Requester(this).with("client_secret", clientSecret).with("scopes", scopes).with("note", note).with("note_url", note_url);
        return (GHAuthorization)((Object)requester.method("PUT").to("/authorizations/clients/" + clientId, GHAuthorization.class));
    }

    public void deleteAuth(long id) throws IOException {
        this.retrieve().method("DELETE").to("/authorizations/" + id);
    }

    public GHAuthorization checkAuth(@Nonnull String clientId, @Nonnull String accessToken) throws IOException {
        return (GHAuthorization)((Object)this.retrieve().to("/applications/" + clientId + "/tokens/" + accessToken, GHAuthorization.class));
    }

    public GHAuthorization resetAuth(@Nonnull String clientId, @Nonnull String accessToken) throws IOException {
        return (GHAuthorization)((Object)this.retrieve().method("POST").to("/applications/" + clientId + "/tokens/" + accessToken, GHAuthorization.class));
    }

    public boolean isCredentialValid() throws IOException {
        try {
            this.retrieve().to("/user", GHUser.class);
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Exception validating credentials on " + this.apiUrl + " with login '" + this.login + "' " + e, e);
            }
            return false;
        }
    }

    GHUser intern(GHUser user) throws IOException {
        if (user == null) {
            return user;
        }
        GHUser u = (GHUser)this.users.get(user.getLogin());
        if (u != null) {
            return u;
        }
        this.users.putIfAbsent(user.getLogin(), user);
        return user;
    }

    public void checkApiUrlValidity() throws IOException {
        try {
            ((GHApiInfo)((Object)this.retrieve().to("/", GHApiInfo.class))).check(this.apiUrl);
        }
        catch (IOException e) {
            if (this.isPrivateModeEnabled()) {
                throw (IOException)new IOException("GitHub Enterprise server (" + this.apiUrl + ") with private mode enabled").initCause(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPrivateModeEnabled() {
        boolean bl;
        HttpURLConnection uc = this.getConnector().connect(this.getApiURL("/"));
        try {
            bl = uc.getResponseCode() == 401 && uc.getHeaderField("X-GitHub-Media-Type") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    IOUtils.closeQuietly((InputStream)uc.getInputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtils.closeQuietly((InputStream)uc.getErrorStream());
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        try {
            IOUtils.closeQuietly((InputStream)uc.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtils.closeQuietly((InputStream)uc.getErrorStream());
        return bl;
    }

    @Preview
    @Deprecated
    public GHCommitSearchBuilder searchCommits() {
        return new GHCommitSearchBuilder(this);
    }

    public GHIssueSearchBuilder searchIssues() {
        return new GHIssueSearchBuilder(this);
    }

    public GHUserSearchBuilder searchUsers() {
        return new GHUserSearchBuilder(this);
    }

    public GHRepositorySearchBuilder searchRepositories() {
        return new GHRepositorySearchBuilder(this);
    }

    public GHContentSearchBuilder searchContent() {
        return new GHContentSearchBuilder(this);
    }

    public GHNotificationStream listNotifications() {
        return new GHNotificationStream(this, "/notifications");
    }

    public PagedIterable<GHRepository> listAllPublicRepositories() {
        return this.listAllPublicRepositories(null);
    }

    public PagedIterable<GHRepository> listAllPublicRepositories(final String since) {
        return new PagedIterable<GHRepository>(){

            @Override
            public PagedIterator<GHRepository> _iterator(int pageSize) {
                return new PagedIterator<GHRepository>(GitHub.this.retrieve().with("since", since).asIterator("/repositories", GHRepository[].class, pageSize)){

                    protected void wrapUp(GHRepository[] page) {
                        for (GHRepository c : page) {
                            c.wrap(GitHub.this);
                        }
                    }
                };
            }
        };
    }

    public Reader renderMarkdown(String text) throws IOException {
        return new InputStreamReader(new Requester(this).with(new ByteArrayInputStream(text.getBytes("UTF-8"))).contentType("text/plain;charset=UTF-8").asStream("/markdown/raw"), "UTF-8");
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        for (String f : TIME_FORMATS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(f);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(timestamp);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalStateException("Unable to parse the timestamp: " + timestamp);
    }

    static String printDate(Date dt) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(dt);
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LOGGER = Logger.getLogger(GitHub.class.getName());
    }

    private static class GHApiInfo {
        private String rate_limit_url;

        private GHApiInfo() {
        }

        void check(String apiUrl) throws IOException {
            if (this.rate_limit_url == null) {
                throw new IOException(apiUrl + " doesn't look like GitHub API URL");
            }
            new URL(this.rate_limit_url);
        }
    }
}

