/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.PeriodicWork;
import java.net.URL;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.jenkinsci.plugins.github.webhook.WebhookManager;

@Extension
public class Cleaner
extends PeriodicWork {
    private final Queue<GitHubRepositoryName> cleanQueue = new ConcurrentLinkedQueue<GitHubRepositoryName>();

    void onStop(Item item) {
        this.cleanQueue.addAll(GitHubRepositoryNameContributor.parseAssociatedNames(item));
    }

    public long getRecurrencePeriod() {
        return TimeUnit.MINUTES.toMillis(3L);
    }

    protected void doRun() throws Exception {
        if (!GitHubPlugin.configuration().isManageHooks()) {
            return;
        }
        URL url = GitHubPlugin.configuration().getHookUrl();
        List items = Jenkins.getInstance().getAllItems(Item.class);
        List<GitHubRepositoryName> aliveRepos = FluentIterableWrapper.from(items).filter(JobInfoHelpers.isAlive()).transformAndConcat(JobInfoHelpers.associatedNames()).toList();
        while (!this.cleanQueue.isEmpty()) {
            GitHubRepositoryName name = this.cleanQueue.poll();
            WebhookManager.forHookUrl(url).unregisterFor(name, aliveRepos);
        }
    }

    public static Cleaner get() {
        return (Cleaner)((Object)PeriodicWork.all().get(Cleaner.class));
    }
}

