/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.misc.NullSafeFunction;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubRepositoryName {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubRepositoryName.class);
    private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("git@(.+):([^/]+)/([^/]+)\\.git"), Pattern.compile("https?://[^/]+@([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("git://([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("ssh://(?:git@)?([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("git@(.+):([^/]+)/([^/]+)/?"), Pattern.compile("https?://[^/]+@([^/]+)/([^/]+)/([^/]+)/?"), Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)/?"), Pattern.compile("git://([^/]+)/([^/]+)/([^/]+)/?"), Pattern.compile("ssh://(?:git@)?([^/]+)/([^/]+)/([^/]+)/?")};
    public final String host;
    public final String userName;
    public final String repositoryName;

    @CheckForNull
    public static GitHubRepositoryName create(String url) {
        LOGGER.debug("Constructing from URL {}", (Object)url);
        for (Pattern p : URL_PATTERNS) {
            Matcher m = p.matcher(StringUtils.trimToEmpty((String)url));
            if (!m.matches()) continue;
            LOGGER.debug("URL matches {}", (Object)m);
            GitHubRepositoryName ret = new GitHubRepositoryName(m.group(1), m.group(2), m.group(3));
            LOGGER.debug("Object is {}", (Object)ret);
            return ret;
        }
        LOGGER.warn("Could not match URL {}", (Object)url);
        return null;
    }

    @CheckForNull
    public static GitHubRepositoryName create(GithubProjectProperty projectProperty) {
        if (projectProperty == null) {
            return null;
        }
        return GitHubRepositoryName.create(projectProperty.getProjectUrlStr());
    }

    public GitHubRepositoryName(String host, String userName, String repositoryName) {
        this.host = host;
        this.userName = userName;
        this.repositoryName = repositoryName;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Iterable<GHRepository> resolve() {
        return this.resolve((Predicate<GitHubServerConfig>)Predicates.alwaysTrue());
    }

    public Iterable<GHRepository> resolve(Predicate<GitHubServerConfig> predicate) {
        return FluentIterableWrapper.from(GitHubPlugin.configuration().findGithubConfig((Predicate<GitHubServerConfig>)Predicates.and(GitHubServerConfig.withHost(this.host), predicate))).transform(GitHubRepositoryName.toGHRepository(this)).filter((Predicate<GHRepository>)Predicates.notNull());
    }

    @CheckForNull
    public GHRepository resolveOne() {
        return (GHRepository)FluentIterableWrapper.from(this.resolve()).first().orNull();
    }

    public boolean matches(GHCommitPointer commit) {
        GHUser user;
        try {
            user = commit.getUser();
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to extract user from commit " + commit, (Throwable)ex);
            return false;
        }
        return this.userName.equals(user.getLogin()) && this.repositoryName.equals(commit.getRepository().getName()) && this.host.equals(commit.getRepository().getHtmlUrl().getHost());
    }

    public boolean matches(GHRepository repo) throws IOException {
        return this.userName.equals(repo.getOwner().getLogin()) && this.repositoryName.equals(repo.getName()) && this.host.equals(repo.getHtmlUrl().getHost());
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.host).append((Object)this.userName).append((Object)this.repositoryName).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("host", (Object)this.host).append("username", (Object)this.userName).append("repository", (Object)this.repositoryName).build();
    }

    private static Function<GitHub, GHRepository> toGHRepository(final GitHubRepositoryName repoName) {
        return new NullSafeFunction<GitHub, GHRepository>(){

            @Override
            protected GHRepository applyNullSafe(@Nonnull GitHub gitHub) {
                try {
                    return gitHub.getRepository(String.format("%s/%s", repoName.getUserName(), repoName.getRepositoryName()));
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to obtain repository {}", (Object)this, (Object)e);
                    return null;
                }
            }
        };
    }
}

