/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins;

public class GitHubTriggerEvent {
    private final long timestamp;
    private final String origin;
    private final String triggeredByUser;

    private GitHubTriggerEvent(long timestamp, String origin, String triggeredByUser) {
        this.timestamp = timestamp;
        this.origin = origin;
        this.triggeredByUser = triggeredByUser;
    }

    public static Builder create() {
        return new Builder();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getTriggeredByUser() {
        return this.triggeredByUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitHubTriggerEvent that = (GitHubTriggerEvent)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.origin != null ? !this.origin.equals(that.origin) : that.origin != null) {
            return false;
        }
        return this.triggeredByUser != null ? this.triggeredByUser.equals(that.triggeredByUser) : that.triggeredByUser == null;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        result = 31 * result + (this.triggeredByUser != null ? this.triggeredByUser.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GitHubTriggerEvent{timestamp=" + this.timestamp + ", origin='" + this.origin + '\'' + ", triggeredByUser='" + this.triggeredByUser + '\'' + '}';
    }

    public static class Builder {
        private long timestamp = System.currentTimeMillis();
        private String origin;
        private String triggeredByUser;

        private Builder() {
        }

        public Builder withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder withTriggeredByUser(String triggeredByUser) {
            this.triggeredByUser = triggeredByUser;
            return this;
        }

        public GitHubTriggerEvent build() {
            return new GitHubTriggerEvent(this.timestamp, this.origin, this.triggeredByUser);
        }

        public String toString() {
            return "GitHubTriggerEvent.Builder{timestamp=" + this.timestamp + ", origin='" + this.origin + '\'' + ", triggeredByUser='" + this.triggeredByUser + '\'' + '}';
        }
    }
}

