/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.base.Function;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import hudson.util.SequentialExecutionQueue;
import java.net.URL;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.lang3.Validate;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github.internal.GHPluginConfigException;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.jenkinsci.plugins.github.webhook.GHEventHeader;
import org.jenkinsci.plugins.github.webhook.GHEventPayload;
import org.jenkinsci.plugins.github.webhook.RequirePostWithGHHookPayload;
import org.jenkinsci.plugins.github.webhook.WebhookManager;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHEvent;
import org.kohsuke.stapler.Stapler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubWebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubWebHook.class);
    public static final String URLNAME = "github-webhook";
    public static final String URL_VALIDATION_HEADER = "X-Jenkins-Validation";
    public static final String X_INSTANCE_IDENTITY = "X-Instance-Identity";
    private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Computer.threadPoolForRemoting);

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    @Deprecated
    public void registerHookFor(Job job) {
        this.reRegisterHookForJob().apply((Object)job);
    }

    public void registerHookFor(Item item) {
        this.reRegisterHookForJob().apply((Object)item);
    }

    public List<Item> reRegisterAllHooks() {
        return FluentIterableWrapper.from(GitHubWebHook.getJenkinsInstance().getAllItems(Item.class)).filter(JobInfoHelpers.isBuildable()).filter(JobInfoHelpers.isAlive()).transform(this.reRegisterHookForJob()).toList();
    }

    @RequirePostWithGHHookPayload
    public void doIndex(@Nonnull @GHEventHeader GHEvent event, @Nonnull @GHEventPayload String payload) {
        GHSubscriberEvent subscriberEvent = new GHSubscriberEvent(SCMEvent.originOf((HttpServletRequest)Stapler.getCurrentRequest()), event, payload);
        FluentIterableWrapper.from(GHEventsSubscriber.all()).filter(GHEventsSubscriber.isInterestedIn(event)).transform(GHEventsSubscriber.processEvent(subscriberEvent)).toList();
    }

    private <T extends Item> Function<T, T> reRegisterHookForJob() {
        return new Function<T, T>(){

            public T apply(T job) {
                URL hookUrl;
                LOGGER.debug("Calling registerHooks() for {}", (Object)((Item)Validate.notNull(job, (String)"Item can't be null", (Object[])new Object[0])).getFullName());
                try {
                    hookUrl = GitHubPlugin.configuration().getHookUrl();
                }
                catch (GHPluginConfigException e) {
                    LOGGER.error("Skip registration of GHHook ({})", (Object)e.getMessage());
                    return job;
                }
                Runnable hookRegistrator = WebhookManager.forHookUrl(hookUrl).registerFor((Item)job);
                GitHubWebHook.this.queue.execute(hookRegistrator);
                return job;
            }
        };
    }

    public static GitHubWebHook get() {
        return (GitHubWebHook)Jenkins.getInstance().getExtensionList(RootAction.class).get(GitHubWebHook.class);
    }

    @Nonnull
    public static Jenkins getJenkinsInstance() throws IllegalStateException {
        Jenkins instance = Jenkins.getInstance();
        Validate.validState((instance != null ? 1 : 0) != 0, (String)"Jenkins has not been started, or was already shut down", (Object[])new Object[0]);
        return instance;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static abstract class Listener
    implements ExtensionPoint {
        public abstract void onPushRepositoryChanged(String var1, GitHubRepositoryName var2);
    }
}

