/*
 * Decompiled with CFR 0.152.
 */
package com.coravy.hudson.plugins.github;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import com.coravy.hudson.plugins.github.GithubUrl;
import hudson.Extension;
import hudson.MarkupText;
import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

@Extension
public class GithubLinkAnnotator
extends ChangeLogAnnotator {
    private static final LinkMarkup[] MARKUPS = new LinkMarkup[]{new LinkMarkup("(?:C|c)lose(?:s?)\\s(?<!\\:)(?:#)NUM", "issues/$1/find")};

    public void annotate(Run<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        GithubProjectProperty p = (GithubProjectProperty)build.getParent().getProperty(GithubProjectProperty.class);
        if (null == p) {
            return;
        }
        this.annotate(p.getProjectUrl(), text, change);
    }

    void annotate(GithubUrl url, MarkupText text, ChangeLogSet.Entry change) {
        String base = url.baseUrl();
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, base);
        }
        if (change instanceof GitChangeSet) {
            GitChangeSet cs = (GitChangeSet)change;
            String id = cs.getId();
            text.wrapBy("", String.format(" (<a href='%s'>commit: %s</a>)", url.commitId(id), id.substring(0, Math.min(id.length(), 7))));
        }
    }

    private static final class LinkMarkup {
        private final Pattern pattern;
        private final String href;
        private static final Pattern NUM_PATTERN = Pattern.compile("NUM");
        private static final Pattern ANYWORD_PATTERN = Pattern.compile("ANYWORD");

        LinkMarkup(String pattern, String href) {
            pattern = NUM_PATTERN.matcher(pattern).replaceAll("(\\\\d+)");
            pattern = ANYWORD_PATTERN.matcher(pattern).replaceAll("((?:\\\\w|[._-])+)");
            this.pattern = Pattern.compile(pattern);
            this.href = href;
        }

        void process(MarkupText text, String url) {
            for (MarkupText.SubText st : text.findTokens(this.pattern)) {
                st.surroundWith("<a href='" + url + this.href + "'>", "</a>");
            }
        }
    }
}

