/*
 * Decompiled with CFR 0.152.
 */
package com.coravy.hudson.plugins.github;

import org.apache.commons.lang.StringUtils;

public final class GithubUrl {
    private final String baseUrl;

    private static String normalize(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (url.contains("/tree/")) {
            url = url.replaceFirst("/tree/.*$", "");
        }
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        return url;
    }

    GithubUrl(String input) {
        this.baseUrl = GithubUrl.normalize(input);
    }

    public String toString() {
        return this.baseUrl;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String commitId(String id) {
        return this.baseUrl + "commit/" + id;
    }
}

