/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.config;

import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.Messages;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.config.GitHubTokenCredentialsCreator;
import org.jenkinsci.plugins.github.config.HookSecretConfig;
import org.jenkinsci.plugins.github.internal.GHPluginConfigException;
import org.jenkinsci.plugins.github.internal.GitHubClientCacheOps;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubPluginConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubPluginConfig.class);
    public static final String GITHUB_PLUGIN_CONFIGURATION_ID = "github-plugin-configuration";
    public static final GitHubPluginConfig EMPTY_CONFIG = new GitHubPluginConfig(Collections.emptyList());
    private List<GitHubServerConfig> configs = new ArrayList<GitHubServerConfig>();
    private URL hookUrl;
    private HookSecretConfig hookSecretConfig = new HookSecretConfig(null);
    private transient boolean overrideHookUrl;
    @Inject
    private transient InstanceIdentity identity;

    public GitHubPluginConfig() {
        this.load();
    }

    public GitHubPluginConfig(List<GitHubServerConfig> configs) {
        this.configs = configs;
    }

    public void setConfigs(List<GitHubServerConfig> configs) {
        this.configs = configs;
    }

    public List<GitHubServerConfig> getConfigs() {
        return this.configs;
    }

    public boolean isManageHooks() {
        return FluentIterableWrapper.from(this.getConfigs()).filter(GitHubServerConfig.allowedToManageHooks()).first().isPresent();
    }

    public void setHookUrl(URL hookUrl) {
        this.hookUrl = this.overrideHookUrl ? hookUrl : null;
    }

    public void setOverrideHookUrl(boolean overrideHookUrl) {
        this.overrideHookUrl = overrideHookUrl;
    }

    public URL getHookUrl() throws GHPluginConfigException {
        if (this.hookUrl != null) {
            return this.hookUrl;
        }
        return GitHubPluginConfig.constructDefaultUrl();
    }

    public boolean isOverrideHookURL() {
        return this.hookUrl != null;
    }

    public Iterable<GitHub> findGithubConfig(Predicate<GitHubServerConfig> match) {
        return FluentIterableWrapper.from(this.getConfigs()).filter(match).transform(GitHubServerConfig.loginToGithub()).filter((Predicate<GitHub>)Predicates.notNull());
    }

    public List<Descriptor> actions() {
        return Collections.singletonList(Jenkins.getInstance().getDescriptor(GitHubTokenCredentialsCreator.class));
    }

    public String getId() {
        return GITHUB_PLUGIN_CONFIGURATION_ID;
    }

    protected XmlFile getConfigFile() {
        return new XmlFile((XStream)Jenkins.XSTREAM2, super.getConfigFile().getFile());
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            req.bindJSON((Object)this, json);
        }
        catch (Exception e) {
            LOGGER.debug("Problem while submitting form for GitHub Plugin ({})", (Object)e.getMessage(), (Object)e);
            LOGGER.trace("GH form data: {}", (Object)json.toString());
            throw new Descriptor.FormException(String.format("Malformed GitHub Plugin configuration (%s)", e.getMessage()), (Throwable)e, "github-configuration");
        }
        this.save();
        GitHubClientCacheOps.clearRedundantCaches(this.configs);
        return true;
    }

    public String getDisplayName() {
        return "GitHub";
    }

    @RequirePOST
    public FormValidation doReRegister() {
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        if (!GitHubPlugin.configuration().isManageHooks()) {
            return FormValidation.warning((String)"Works only when Jenkins manages hooks (one or more creds specified)");
        }
        List<Item> registered = GitHubWebHook.get().reRegisterAllHooks();
        LOGGER.info("Called registerHooks() for {} items", (Object)registered.size());
        return FormValidation.ok((String)"Called re-register hooks for %s items", (Object[])new Object[]{registered.size()});
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckHookUrl(@QueryParameter String value) {
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(value).openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("X-Jenkins-Validation", "true");
            con.connect();
            if (con.getResponseCode() != 200) {
                return FormValidation.error((String)"Got %d from %s", (Object[])new Object[]{con.getResponseCode(), value});
            }
            String v = con.getHeaderField("X-Instance-Identity");
            if (v == null) {
                return FormValidation.warning((String)"It doesn't look like %s is talking to any Jenkins. Are you running your own app?", (Object[])new Object[]{value});
            }
            RSAPublicKey key = this.identity.getPublic();
            String expected = new String(Base64.encodeBase64((byte[])key.getEncoded()), Charsets.UTF_8);
            if (!expected.equals(v)) {
                return FormValidation.error((String)"%s is connecting to different Jenkins instances", (Object[])new Object[]{value});
            }
            return FormValidation.ok();
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)"Failed to test a connection to %s", (Object[])new Object[]{value});
        }
    }

    private static URL constructDefaultUrl() {
        String jenkinsUrl = Jenkins.getInstance().getRootUrl();
        GitHubPluginConfig.validateConfig(StringUtils.isNotEmpty((CharSequence)jenkinsUrl), Messages.global_config_url_is_empty());
        try {
            return new URL(jenkinsUrl + GitHubWebHook.get().getUrlName() + '/');
        }
        catch (MalformedURLException e) {
            throw new GHPluginConfigException(Messages.global_config_hook_url_is_malformed(e.getMessage()), new Object[0]);
        }
    }

    private static void validateConfig(boolean state, String message) {
        if (!state) {
            throw new GHPluginConfigException(message, new Object[0]);
        }
    }

    public HookSecretConfig getHookSecretConfig() {
        return this.hookSecretConfig;
    }

    public void setHookSecretConfig(HookSecretConfig hookSecretConfig) {
        this.hookSecretConfig = hookSecretConfig;
    }
}

