/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.config;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.github.GHAuthorization;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubTokenCredentialsCreator
extends Descriptor<GitHubTokenCredentialsCreator>
implements Describable<GitHubTokenCredentialsCreator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubTokenCredentialsCreator.class);
    public static final List<String> GH_PLUGIN_REQUIRED_SCOPE = ImmutableList.of((Object)"admin:repo_hook", (Object)"repo", (Object)"repo:status");

    public GitHubTokenCredentialsCreator() {
        super(GitHubTokenCredentialsCreator.class);
    }

    public GitHubTokenCredentialsCreator getDescriptor() {
        return this;
    }

    public String getDisplayName() {
        return "Convert login and password to token";
    }

    public ListBoxModel doFillCredentialsIdItems(@QueryParameter String apiUrl, @QueryParameter String credentialsId) {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardUsernameListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)"https://api.github.com"))).build(), CredentialsMatchers.always()).includeMatchingAs(Jenkins.getAuthentication(), (ItemGroup)Jenkins.getInstance(), StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)"https://api.github.com"))).build(), CredentialsMatchers.always());
    }

    @RequirePOST
    public FormValidation doCreateTokenByCredentials(@QueryParameter String apiUrl, @QueryParameter String credentialsId) {
        GHAuthorization token;
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        if (StringUtils.isEmpty((CharSequence)credentialsId)) {
            return FormValidation.error((String)"Please specify credentials to create token");
        }
        StandardUsernamePasswordCredentials creds = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)"https://api.github.com"))).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (creds == null) {
            creds = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)Jenkins.getAuthentication(), (List)URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)"https://api.github.com"))).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        }
        try {
            token = this.createToken(((StandardUsernamePasswordCredentials)Validate.notNull((Object)creds, (String)"Why selected creds is null?", (Object[])new Object[0])).getUsername(), creds.getPassword().getPlainText(), (String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)"https://api.github.com"));
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)"Can't create GH token - %s", (Object[])new Object[]{e.getMessage()});
        }
        StandardCredentials credentials = this.createCredentials(apiUrl, token.getToken(), creds.getUsername());
        return FormValidation.ok((String)"Created credentials with id %s (can use it for GitHub Server Config)", (Object[])new Object[]{credentials.getId()});
    }

    @RequirePOST
    public FormValidation doCreateTokenByPassword(@QueryParameter String apiUrl, @QueryParameter String login, @QueryParameter String password) {
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            GHAuthorization token = this.createToken(login, password, (String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)"https://api.github.com"));
            StandardCredentials credentials = this.createCredentials(apiUrl, token.getToken(), login);
            return FormValidation.ok((String)"Created credentials with id %s (can use it for GitHub Server Config)", (Object[])new Object[]{credentials.getId()});
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)"Can't create GH token for %s - %s", (Object[])new Object[]{login, e.getMessage()});
        }
    }

    public GHAuthorization createToken(@Nonnull String username, @Nonnull String password, @Nullable String apiUrl) throws IOException {
        GitHub gitHub = new GitHubBuilder().withEndpoint((String)StringUtils.defaultIfBlank((CharSequence)apiUrl, (CharSequence)"https://api.github.com")).withPassword(username, password).build();
        return gitHub.createToken(GH_PLUGIN_REQUIRED_SCOPE, String.format("Jenkins GitHub Plugin token (%s)", Jenkins.getInstance().getRootUrl()), Jenkins.getInstance().getRootUrl());
    }

    public StandardCredentials createCredentials(@Nullable String serverAPIUrl, String token, String username) {
        String url = (String)StringUtils.defaultIfBlank((CharSequence)serverAPIUrl, (CharSequence)"https://api.github.com");
        String description = String.format("GitHub (%s) auto generated token credentials for %s", url, username);
        StringCredentialsImpl creds = new StringCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), description, Secret.fromString((String)token));
        return this.createCredentials(url, (StandardCredentials)creds);
    }

    private StandardCredentials createCredentials(@Nonnull String serverAPIUrl, final StandardCredentials credentials) {
        URI serverUri = URI.create((String)StringUtils.defaultIfBlank((CharSequence)serverAPIUrl, (CharSequence)"https://api.github.com"));
        List<DomainSpecification> specifications = Arrays.asList(new SchemeSpecification(serverUri.getScheme()), new HostnameSpecification(serverUri.getHost(), null));
        final Domain domain = new Domain(serverUri.getHost(), "GitHub domain (autogenerated)", specifications);
        ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    new SystemCredentialsProvider.StoreImpl().addDomain(domain, new Credentials[]{credentials});
                }
                catch (IOException e) {
                    LOGGER.error("Can't add creds for domain", (Throwable)e);
                }
            }
        });
        return credentials;
    }
}

