/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.migration;

import com.cloudbees.jenkins.Credential;
import com.cloudbees.jenkins.GitHubPushTrigger;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.config.GitHubPluginConfig;
import org.jenkinsci.plugins.github.config.GitHubServerConfig;
import org.jenkinsci.plugins.github.config.GitHubTokenCredentialsCreator;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migrator.class);

    public void migrate() throws IOException {
        LOGGER.debug("Check if GitHub Plugin needs config migration");
        GitHubPushTrigger.DescriptorImpl descriptor = GitHubPushTrigger.DescriptorImpl.get();
        descriptor.load();
        if (CollectionUtils.isNotEmpty(descriptor.getCredentials())) {
            LOGGER.warn("Migration for old GitHub Plugin credentials started");
            GitHubPlugin.configuration().getConfigs().addAll(FluentIterableWrapper.from(descriptor.getCredentials()).transform(this.toGHServerConfig()).toList());
            descriptor.clearCredentials();
            descriptor.save();
            GitHubPlugin.configuration().save();
        }
        if (descriptor.getDeprecatedHookUrl() != null) {
            LOGGER.warn("Migration for old GitHub Plugin hook url started");
            GitHubPlugin.configuration().setOverrideHookUrl(true);
            GitHubPlugin.configuration().setHookUrl(descriptor.getDeprecatedHookUrl());
            descriptor.clearDeprecatedHookUrl();
            descriptor.save();
            GitHubPlugin.configuration().save();
        }
    }

    @VisibleForTesting
    protected Function<Credential, GitHubServerConfig> toGHServerConfig() {
        return new Function<Credential, GitHubServerConfig>(){

            public GitHubServerConfig apply(Credential input) {
                LOGGER.info("Migrate GitHub Plugin creds for {} {}", (Object)input.getUsername(), (Object)input.getApiUrl());
                GitHubTokenCredentialsCreator creator = (GitHubTokenCredentialsCreator)Jenkins.getInstance().getDescriptorByType(GitHubTokenCredentialsCreator.class);
                StandardCredentials credentials = creator.createCredentials(input.getApiUrl(), input.getOauthAccessToken(), input.getUsername());
                GitHubServerConfig gitHubServerConfig = new GitHubServerConfig(credentials.getId());
                gitHubServerConfig.setApiUrl(input.getApiUrl());
                return gitHubServerConfig;
            }
        };
    }

    public static void enableCompatibilityAliases() {
    }

    public static void enableAliases() {
        Jenkins.XSTREAM2.alias("github-plugin-configuration", GitHubPluginConfig.class);
    }
}

