/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.sources;

import com.cloudbees.jenkins.Messages;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusResultSource;
import org.jenkinsci.plugins.github.extension.status.misc.ConditionalResult;
import org.jenkinsci.plugins.github.status.sources.ConditionalStatusResultSource;
import org.jenkinsci.plugins.github.status.sources.misc.AnyBuildResult;
import org.jenkinsci.plugins.github.status.sources.misc.BetterThanOrEqualBuildResult;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultStatusResultSource
extends GitHubStatusResultSource {
    @DataBoundConstructor
    public DefaultStatusResultSource() {
    }

    @Override
    public GitHubStatusResultSource.StatusResult get(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        String duration = Util.getTimeSpanString((long)(System.currentTimeMillis() - run.getTimeInMillis()));
        return new ConditionalStatusResultSource(Arrays.asList(new ConditionalResult[]{BetterThanOrEqualBuildResult.betterThanOrEqualTo(Result.SUCCESS, GHCommitState.SUCCESS, Messages.CommitNotifier_Success(run.getDisplayName(), duration)), BetterThanOrEqualBuildResult.betterThanOrEqualTo(Result.UNSTABLE, GHCommitState.FAILURE, Messages.CommitNotifier_Unstable(run.getDisplayName(), duration)), BetterThanOrEqualBuildResult.betterThanOrEqualTo(Result.FAILURE, GHCommitState.ERROR, Messages.CommitNotifier_Failed(run.getDisplayName(), duration)), AnyBuildResult.onAnyResult(GHCommitState.PENDING, Messages.CommitNotifier_Pending(run.getDisplayName()))})).get(run, listener);
    }

    @Extension
    public static class DefaultResultSourceDescriptor
    extends Descriptor<GitHubStatusResultSource> {
        public String getDisplayName() {
            return "One of default messages and statuses";
        }
    }
}

