/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.status.sources;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.github.common.ExpandableMessage;
import org.jenkinsci.plugins.github.extension.status.GitHubStatusContextSource;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManuallyEnteredCommitContextSource
extends GitHubStatusContextSource {
    private static final Logger LOG = LoggerFactory.getLogger(ManuallyEnteredCommitContextSource.class);
    private String context;

    @DataBoundConstructor
    public ManuallyEnteredCommitContextSource(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    @Override
    public String context(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener) {
        try {
            return new ExpandableMessage(this.context).expandAll(run, listener);
        }
        catch (Exception e) {
            LOG.debug("Can't expand context, returning as is", (Throwable)e);
            return this.context;
        }
    }

    @Extension
    public static class ManuallyEnteredCommitContextSourceDescriptor
    extends Descriptor<GitHubStatusContextSource> {
        public String getDisplayName() {
            return "Manually entered context name";
        }
    }
}

