/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.util;

import hudson.model.Run;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.github.util.Messages;

public final class BuildDataHelper {
    private BuildDataHelper() {
    }

    @Nonnull
    public static ObjectId getCommitSHA1(@Nonnull Run<?, ?> build) throws IOException {
        BuildData buildData = (BuildData)build.getAction(BuildData.class);
        if (buildData == null) {
            throw new IOException(Messages.BuildDataHelper_NoBuildDataError());
        }
        Build b = buildData.lastBuild;
        if (b != null) {
            Revision r = b.marked;
            if (r == null) {
                r = b.revision;
            }
            if (r != null) {
                return r.getSha1();
            }
        }
        throw new IOException(Messages.BuildDataHelper_NoLastRevisionError());
    }
}

