/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class FluentIterableWrapper<E>
implements Iterable<E> {
    private final Iterable<E> iterable;

    FluentIterableWrapper(Iterable<E> iterable) {
        this.iterable = (Iterable)Preconditions.checkNotNull(iterable);
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterable.iterator();
    }

    public static <E> FluentIterableWrapper<E> from(Iterable<E> iterable) {
        return iterable instanceof FluentIterableWrapper ? (FluentIterableWrapper<E>)iterable : new FluentIterableWrapper<E>((Iterable)iterable){};
    }

    @CheckReturnValue
    public final FluentIterableWrapper<E> append(Iterable<? extends E> other) {
        return FluentIterableWrapper.from(Iterables.concat(this.iterable, other));
    }

    @CheckReturnValue
    public final FluentIterableWrapper<E> filter(Predicate<? super E> predicate) {
        return FluentIterableWrapper.from(Iterables.filter(this.iterable, predicate));
    }

    @CheckReturnValue
    public final <F extends E> FluentIterableWrapper<F> filter(Class<F> clazz) {
        return FluentIterableWrapper.from(Iterables.filter(this.iterable, clazz));
    }

    public final <T> FluentIterableWrapper<T> transform(Function<? super E, T> function) {
        return FluentIterableWrapper.from(Iterables.transform(this.iterable, function));
    }

    public <T> FluentIterableWrapper<T> transformAndConcat(Function<? super E, ? extends Iterable<? extends T>> function) {
        return FluentIterableWrapper.from(Iterables.concat(this.transform(function)));
    }

    public final Optional<E> firstMatch(Predicate<? super E> predicate) {
        return Iterables.tryFind(this.iterable, predicate);
    }

    public final Optional<E> first() {
        Iterator<E> iterator = this.iterable.iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.absent();
    }

    public List<E> toList() {
        return Lists.newArrayList(this.iterable);
    }

    public final ImmutableSet<E> toSet() {
        return ImmutableSet.copyOf(this.iterable);
    }
}

