/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.util;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import java.util.Collection;
import javax.annotation.CheckForNull;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;

public final class JobInfoHelpers {
    private JobInfoHelpers() {
        throw new IllegalAccessError("Do not instantiate it");
    }

    public static <ITEM extends Item> Predicate<ITEM> withTrigger(final Class<? extends Trigger> clazz) {
        return new Predicate<ITEM>(){

            public boolean apply(Item item) {
                return JobInfoHelpers.triggerFrom(item, clazz) != null;
            }
        };
    }

    public static <ITEM extends Item> Predicate<ITEM> isBuildable() {
        return new Predicate<ITEM>(){

            public boolean apply(ITEM item) {
                return item instanceof Job ? ((Job)item).isBuildable() : item instanceof BuildableItem;
            }
        };
    }

    public static <ITEM extends Item> Function<ITEM, Collection<GitHubRepositoryName>> associatedNames() {
        return new Function<ITEM, Collection<GitHubRepositoryName>>(){

            public Collection<GitHubRepositoryName> apply(ITEM item) {
                return GitHubRepositoryNameContributor.parseAssociatedNames(item);
            }
        };
    }

    public static <ITEM extends Item> Predicate<ITEM> isAlive() {
        return new Predicate<ITEM>(){

            public boolean apply(ITEM item) {
                return !FluentIterableWrapper.from(GHEventsSubscriber.all()).filter(GHEventsSubscriber.isApplicableFor(item)).toList().isEmpty();
            }
        };
    }

    @Deprecated
    @CheckForNull
    public static <T extends Trigger> T triggerFrom(Job<?, ?> job, Class<T> tClass) {
        return JobInfoHelpers.triggerFrom(job, tClass);
    }

    @CheckForNull
    public static <T extends Trigger> T triggerFrom(Item item, Class<T> tClass) {
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)item;
            for (Trigger candidate : pJob.getTriggers().values()) {
                if (!tClass.isInstance(candidate)) continue;
                return (T)((Trigger)tClass.cast(candidate));
            }
        }
        return null;
    }

    public static <T extends Job> ParameterizedJobMixIn asParameterizedJobMixIn(final T job) {
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        };
    }
}

