/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

import com.google.common.base.Preconditions;
import hudson.util.Secret;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHWebhookSignature {
    private static final Logger LOGGER = LoggerFactory.getLogger(GHWebhookSignature.class);
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public static final String INVALID_SIGNATURE = "COMPUTED_INVALID_SIGNATURE";
    private final String payload;
    private final Secret secret;

    private GHWebhookSignature(String payload, Secret secret) {
        this.payload = payload;
        this.secret = secret;
    }

    public static GHWebhookSignature webhookSignature(String payload, Secret secret) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload can't be null");
        Preconditions.checkNotNull((Object)secret, (Object)"Secret should be defined to compute sign");
        return new GHWebhookSignature(payload, secret);
    }

    public String sha1() {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.secret.getPlainText().getBytes(StandardCharsets.UTF_8), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(keySpec);
            byte[] rawHMACBytes = mac.doFinal(this.payload.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])rawHMACBytes);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return INVALID_SIGNATURE;
        }
    }

    public boolean matches(String digest) {
        String computed = this.sha1();
        LOGGER.trace("Signature: calculated={} provided={}", (Object)computed, (Object)digest);
        return StringUtils.equals((CharSequence)computed, (CharSequence)digest);
    }
}

