/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import hudson.util.Secret;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.ServletException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.plugins.github.GitHubPlugin;
import org.jenkinsci.plugins.github.util.FluentIterableWrapper;
import org.jenkinsci.plugins.github.webhook.GHWebhookSignature;
import org.kohsuke.github.GHEvent;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD})
@InterceptorAnnotation(value=Processor.class)
public @interface RequirePostWithGHHookPayload {

    public static class Processor
    extends Interceptor {
        private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class);
        public static final String SIGNATURE_HEADER = "X-Hub-Signature";
        private static final String SHA1_PREFIX = "sha1=";

        public Object invoke(StaplerRequest req, StaplerResponse rsp, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
            this.shouldBePostMethod(req);
            this.returnsInstanceIdentityIfLocalUrlTest(req);
            this.shouldContainParseablePayload(arguments);
            this.shouldProvideValidSignature(req, arguments);
            return this.target.invoke(req, rsp, instance, arguments);
        }

        protected void shouldBePostMethod(StaplerRequest request) throws InvocationTargetException {
            if (!request.getMethod().equals("POST")) {
                throw new InvocationTargetException((Throwable)HttpResponses.error((int)405, (String)"Method POST required"));
            }
        }

        protected void returnsInstanceIdentityIfLocalUrlTest(StaplerRequest req) throws InvocationTargetException {
            if (req.getHeader("X-Jenkins-Validation") != null) {
                throw new InvocationTargetException((Throwable)new HttpResponses.HttpResponseException(){

                    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                        RSAPublicKey key = new InstanceIdentity().getPublic();
                        rsp.setStatus(200);
                        rsp.setHeader("X-Instance-Identity", new String(Base64.encodeBase64((byte[])key.getEncoded()), Charsets.UTF_8));
                    }
                });
            }
        }

        protected void shouldContainParseablePayload(Object[] arguments) throws InvocationTargetException {
            this.isTrue(arguments.length == 2, "GHHook root action should take <(GHEvent) event> and <(String) payload> only");
            FluentIterableWrapper from = FluentIterableWrapper.from(Lists.newArrayList((Object[])arguments));
            this.isTrue(from.firstMatch(Predicates.instanceOf(GHEvent.class)).isPresent(), "Hook should contain event type");
            this.isTrue(StringUtils.isNotBlank((CharSequence)((String)from.firstMatch(Predicates.instanceOf(String.class)).or((Object)""))), "Hook should contain payload");
        }

        protected void shouldProvideValidSignature(StaplerRequest req, Object[] args) throws InvocationTargetException {
            Secret secret = GitHubPlugin.configuration().getHookSecretConfig().getHookSecret();
            if (Optional.fromNullable((Object)secret).isPresent()) {
                Optional signHeader = Optional.fromNullable((Object)req.getHeader(SIGNATURE_HEADER));
                this.isTrue(signHeader.isPresent(), "Signature was expected, but not provided");
                String digest = StringUtils.substringAfter((String)((String)signHeader.get()), (String)SHA1_PREFIX);
                LOGGER.trace("Trying to verify sign from header {}", signHeader.get());
                this.isTrue(GHWebhookSignature.webhookSignature(this.payloadFrom(req, args), secret).matches(digest), String.format("Provided signature [%s] did not match to calculated", digest));
            }
        }

        protected String payloadFrom(StaplerRequest req, Object[] args) {
            String parsedPayload = (String)args[1];
            if (req.getContentType().equals("application/json")) {
                return parsedPayload;
            }
            if (req.getContentType().equals("application/x-www-form-urlencoded")) {
                try {
                    return String.format("payload=%s", URLEncoder.encode(parsedPayload, StandardCharsets.UTF_8.toString()));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.error("Unknown content type {}", (Object)req.getContentType());
            }
            return "";
        }

        private void isTrue(boolean condition, String msg) throws InvocationTargetException {
            if (!condition) {
                throw new InvocationTargetException((Throwable)HttpResponses.errorWithoutStack((int)400, (String)msg));
            }
        }
    }
}

