/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook.subscriber;

import com.cloudbees.jenkins.GitHubPushTrigger;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.cloudbees.jenkins.GitHubTriggerEvent;
import com.cloudbees.jenkins.GitHubWebHook;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.security.ACL;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Set;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github.util.JobInfoHelpers;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DefaultPushGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPushGHEventSubscriber.class);

    @Override
    protected boolean isApplicable(Item project) {
        return JobInfoHelpers.withTrigger(GitHubPushTrigger.class).apply((Object)project);
    }

    @Override
    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PUSH, (Enum[])new GHEvent[0]);
    }

    @Override
    protected void onEvent(final GHSubscriberEvent event) {
        GHEventPayload.Push push;
        try {
            push = (GHEventPayload.Push)GitHub.offline().parseEventPayload((Reader)new StringReader((String)event.getPayload()), GHEventPayload.Push.class);
        }
        catch (IOException e) {
            LOGGER.warn("Received malformed PushEvent: " + (String)event.getPayload(), (Throwable)e);
            return;
        }
        URL repoUrl = push.getRepository().getUrl();
        final String pusherName = push.getPusher().getName();
        LOGGER.info("Received PushEvent for {} from {}", (Object)repoUrl, (Object)event.getOrigin());
        final GitHubRepositoryName changedRepository = GitHubRepositoryName.create(repoUrl.toExternalForm());
        if (changedRepository != null) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Item job : Jenkins.getInstance().getAllItems(Item.class)) {
                        GitHubPushTrigger trigger = JobInfoHelpers.triggerFrom(job, GitHubPushTrigger.class);
                        if (trigger == null) continue;
                        String fullDisplayName = job.getFullDisplayName();
                        LOGGER.debug("Considering to poke {}", (Object)fullDisplayName);
                        if (GitHubRepositoryNameContributor.parseAssociatedNames(job).contains(changedRepository)) {
                            LOGGER.info("Poked {}", (Object)fullDisplayName);
                            trigger.onPost(GitHubTriggerEvent.create().withTimestamp(event.getTimestamp()).withOrigin(event.getOrigin()).withTriggeredByUser(pusherName).build());
                            continue;
                        }
                        LOGGER.debug("Skipped {} because it doesn't have a matching repository.", (Object)fullDisplayName);
                    }
                }
            });
            for (GitHubWebHook.Listener listener : ExtensionList.lookup(GitHubWebHook.Listener.class)) {
                listener.onPushRepositoryChanged(pusherName, changedRepository);
            }
        } else {
            LOGGER.warn("Malformed repo url {}", (Object)repoUrl);
        }
    }
}

