/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import hudson.model.Descriptor;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainerDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public interface AuthorizationContainer {
    public void add(Permission var1, String var2);

    public Map<Permission, Set<String>> getGrantedPermissions();

    public Descriptor getDescriptor();

    @Restricted(value={NoExternalUse.class})
    default public void add(String shortForm) {
        int idx = shortForm.indexOf(58);
        Permission p = Permission.fromId((String)shortForm.substring(0, idx));
        if (p == null) {
            throw new IllegalArgumentException("Failed to parse '" + shortForm + "' --- no such permission");
        }
        String sid = shortForm.substring(idx + 1);
        if (!p.isContainedBy(((AuthorizationContainerDescriptor)this.getDescriptor()).getPermissionScope())) {
            Logger.getLogger(AuthorizationContainer.class.getName()).log(Level.WARNING, "Tried to add inapplicable permission " + p + " for " + sid + " in " + this + ", skipping");
            return;
        }
        this.add(p, shortForm.substring(idx + 1));
    }

    default public List<String> getAllSIDs() {
        TreeSet<String> r = new TreeSet<String>(new IdStrategyComparator());
        for (Set<String> set : this.getGrantedPermissions().values()) {
            r.addAll(set);
        }
        r.remove("anonymous");
        Object[] data = r.toArray(new String[r.size()]);
        Arrays.sort(data);
        return Arrays.asList(data);
    }

    @Restricted(value={NoExternalUse.class})
    default public boolean isAnyRelevantDangerousPermissionExplicitlyGranted() {
        for (String sid : this.getAllSIDs()) {
            if (!this.isAnyRelevantDangerousPermissionExplicitlyGranted(sid)) continue;
            return true;
        }
        return this.isAnyRelevantDangerousPermissionExplicitlyGranted("anonymous");
    }

    @Restricted(value={NoExternalUse.class})
    default public boolean isAnyRelevantDangerousPermissionExplicitlyGranted(String sid) {
        for (Permission p : GlobalMatrixAuthorizationStrategy.DANGEROUS_PERMISSIONS) {
            if (this.hasPermission(sid, Jenkins.ADMINISTER) || !this.hasExplicitPermission(sid, p)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasPermission(String sid, Permission p) {
        if (!GlobalMatrixAuthorizationStrategy.ENABLE_DANGEROUS_PERMISSIONS && GlobalMatrixAuthorizationStrategy.DANGEROUS_PERMISSIONS.contains(p)) {
            return this.hasPermission(sid, Jenkins.ADMINISTER);
        }
        SecurityRealm securityRealm = Jenkins.getInstance().getSecurityRealm();
        IdStrategy groupIdStrategy = securityRealm.getGroupIdStrategy();
        IdStrategy userIdStrategy = securityRealm.getUserIdStrategy();
        while (p != null) {
            Set<String> set;
            if (p.getEnabled() && (set = this.getGrantedPermissions().get(p)) != null) {
                if (set.contains(sid)) {
                    return true;
                }
                for (String s : set) {
                    if (!userIdStrategy.equals(s, sid) && !groupIdStrategy.equals(s, sid)) continue;
                    return true;
                }
            }
            p = p.impliedBy;
        }
        return false;
    }

    default public boolean hasPermission(String sid, Permission p, boolean principal) {
        IdStrategy strategy;
        if (!GlobalMatrixAuthorizationStrategy.ENABLE_DANGEROUS_PERMISSIONS && GlobalMatrixAuthorizationStrategy.DANGEROUS_PERMISSIONS.contains(p)) {
            return this.hasPermission(sid, Jenkins.ADMINISTER, principal);
        }
        SecurityRealm securityRealm = Jenkins.getInstance().getSecurityRealm();
        IdStrategy idStrategy = strategy = principal ? securityRealm.getUserIdStrategy() : securityRealm.getGroupIdStrategy();
        while (p != null) {
            Set<String> set;
            if (p.getEnabled() && (set = this.getGrantedPermissions().get(p)) != null) {
                if (set.contains(sid)) {
                    return true;
                }
                for (String s : set) {
                    if (!strategy.equals(s, sid)) continue;
                    return true;
                }
            }
            p = p.impliedBy;
        }
        return false;
    }

    default public boolean hasExplicitPermission(String sid, Permission p) {
        if (sid == null) {
            return false;
        }
        Set<String> set = this.getGrantedPermissions().get(p);
        if (set != null && p.getEnabled()) {
            if (set.contains(sid)) {
                return true;
            }
            SecurityRealm securityRealm = Jenkins.getInstance().getSecurityRealm();
            IdStrategy groupIdStrategy = securityRealm.getGroupIdStrategy();
            IdStrategy userIdStrategy = securityRealm.getUserIdStrategy();
            for (String s : set) {
                if (!userIdStrategy.equals(s, sid) && !groupIdStrategy.equals(s, sid)) continue;
                return true;
            }
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public static class IdStrategyComparator
    implements Comparator<String> {
        private final SecurityRealm securityRealm = Jenkins.getInstance().getSecurityRealm();
        private final IdStrategy groupIdStrategy = this.securityRealm.getGroupIdStrategy();
        private final IdStrategy userIdStrategy = this.securityRealm.getUserIdStrategy();

        @Override
        public int compare(String o1, String o2) {
            int r = this.userIdStrategy.compare(o1, o2);
            if (r == 0) {
                r = this.groupIdStrategy.compare(o1, o2);
            }
            return r;
        }
    }
}

