/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Indenter;
import hudson.Plugin;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporters;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.PomInfo;
import hudson.maven.local_repo.DefaultLocalRepositoryLocator;
import hudson.maven.local_repo.LocalRepositoryLocator;
import hudson.maven.local_repo.PerJobLocalRepositoryLocator;
import hudson.maven.reporters.MavenMailer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.ResourceActivity;
import hudson.model.Result;
import hudson.model.SCMedItem;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Builder;
import hudson.tasks.Fingerprinter;
import hudson.tasks.JavadocArchiver;
import hudson.tasks.Mailer;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Function1;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.mvn.FilePathSettingsProvider;
import jenkins.mvn.GlobalMavenConfig;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.GlobalSettingsProviderDescriptor;
import jenkins.mvn.SettingsProvider;
import jenkins.mvn.SettingsProviderDescriptor;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public class MavenModuleSet
extends AbstractMavenProject<MavenModuleSet, MavenModuleSetBuild>
implements TopLevelItem,
ItemGroup<MavenModule>,
SCMedItem,
Saveable,
BuildableItemWithBuildWrappers {
    transient Map<ModuleName, MavenModule> modules = new CopyOnWriteMap.Tree();
    transient List<MavenModule> sortedActiveModules;
    private ModuleName rootModule;
    private String rootPOM;
    private String goals;
    private transient String alternateSettings;
    private String defaultGoals;
    private String mavenName;
    private String mavenOpts;
    private boolean aggregatorStyleBuild = true;
    private boolean incrementalBuild = false;
    private transient Boolean usePrivateRepository;
    private LocalRepositoryLocator localRepository = null;
    private boolean ignoreUpstremChanges = false;
    private boolean ignoreUnsuccessfulUpstreams = false;
    private boolean archivingDisabled = false;
    private boolean siteArchivingDisabled = false;
    private boolean fingerprintingDisabled = false;
    private boolean resolveDependencies = false;
    private boolean processPlugins = false;
    private int mavenValidationLevel = -1;
    private boolean runHeadless = false;
    private String settingConfigId;
    private String globalSettingConfigId;
    private boolean disableTriggerDownstreamProjects;
    private Boolean blockTriggerWhenBuilding;
    protected transient String globalSettingConfigPath;
    private SettingsProvider settings;
    private GlobalSettingsProvider globalSettings;
    private DescribableList<MavenReporter, Descriptor<MavenReporter>> reporters = new DescribableList((Saveable)this);
    private DescribableList<Publisher, Descriptor<Publisher>> publishers = new DescribableList((Saveable)this);
    private DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers = new DescribableList((Saveable)this);
    private DescribableList<Builder, Descriptor<Builder>> prebuilders = new DescribableList((Saveable)this);
    private DescribableList<Builder, Descriptor<Builder>> postbuilders = new DescribableList((Saveable)this);
    private Result runPostStepsIfResult;
    @Extension(ordinal=900.0)
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(MavenModuleSet.class.getName());

    public Object readResolve() {
        SettingsProvider newInstance;
        Class<SettingsProvider> legacySettings;
        Plugin plugin = null;
        if (!(!StringUtils.isNotBlank((String)this.settingConfigId) && !StringUtils.isNotBlank((String)this.globalSettingConfigId) || (plugin = Jenkins.getInstance().getPlugin("config-file-provider")) != null && plugin.getWrapper().isEnabled())) {
            LOGGER.severe(Messages.MavenModuleSet_readResolve_missingConfigProvider());
        }
        if (this.alternateSettings != null) {
            this.settings = new FilePathSettingsProvider(this.alternateSettings);
            this.alternateSettings = null;
        } else if (plugin != null && StringUtils.isNotBlank((String)this.settingConfigId)) {
            try {
                legacySettings = plugin.getWrapper().classLoader.loadClass("org.jenkinsci.plugins.configfiles.maven.job.MvnSettingsProvider").asSubclass(SettingsProvider.class);
                newInstance = legacySettings.newInstance();
                PropertyUtils.setProperty((Object)newInstance, (String)"settingsConfigId", (Object)this.settingConfigId);
                this.settings = newInstance;
                this.settingConfigId = null;
            }
            catch (Exception e) {
                LOGGER.severe(Messages.MavenModuleSet_readResolve_updateConfigProvider(this.settingConfigId));
                e.printStackTrace();
            }
        }
        if (plugin != null && StringUtils.isNotBlank((String)this.globalSettingConfigId)) {
            try {
                legacySettings = plugin.getWrapper().classLoader.loadClass("org.jenkinsci.plugins.configfiles.maven.job.MvnGlobalSettingsProvider").asSubclass(GlobalSettingsProvider.class);
                newInstance = (GlobalSettingsProvider)legacySettings.newInstance();
                PropertyUtils.setProperty((Object)newInstance, (String)"settingsConfigId", (Object)this.globalSettingConfigId);
                this.globalSettings = newInstance;
                this.globalSettingConfigId = null;
            }
            catch (Exception e) {
                LOGGER.severe(Messages.MavenModuleSet_readResolve_updateConfigProvider(this.globalSettingConfigId));
                e.printStackTrace();
            }
        }
        return this;
    }

    public MavenModuleSet(String name) {
        this((ItemGroup)Jenkins.getInstance(), name);
    }

    public MavenModuleSet(ItemGroup parent, String name) {
        super(parent, name);
    }

    public DescribableList<Builder, Descriptor<Builder>> getPrebuilders() {
        return this.prebuilders;
    }

    public DescribableList<Builder, Descriptor<Builder>> getPostbuilders() {
        return this.postbuilders;
    }

    void addPostBuilder(Builder builder) throws IOException {
        this.postbuilders.add((Object)builder);
    }

    public Result getRunPostStepsIfResult() {
        return (Result)Functions.defaulted((Object)this.runPostStepsIfResult, (Object)Result.FAILURE);
    }

    public void setRunPostStepsIfResult(Result v) {
        this.runPostStepsIfResult = (Result)Functions.defaulted((Object)v, (Object)Result.FAILURE);
    }

    public String getUrlChildPrefix() {
        return ".";
    }

    public Collection<MavenModule> getItems() {
        return this.modules.values();
    }

    @Exported
    public Collection<MavenModule> getModules() {
        return this.getItems();
    }

    public MavenModule getItem(String name) {
        try {
            return this.modules.get(ModuleName.fromString(name));
        }
        catch (IllegalArgumentException x) {
            return null;
        }
    }

    public MavenModule getModule(String name) {
        return this.getItem(name);
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)Messages.MavenModuleSet_Pronoun());
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
    }

    @Override
    protected List<Action> createTransientActions() {
        List<Action> r = super.createTransientActions();
        for (MavenModule module : this.modules.values()) {
            module.updateTransientActions();
        }
        if (this.publishers != null) {
            for (BuildStep step : this.publishers) {
                r.addAll(step.getProjectActions((AbstractProject)this));
            }
        }
        if (this.buildWrappers != null) {
            for (BuildStep step : this.buildWrappers) {
                r.addAll(step.getProjectActions((AbstractProject)this));
            }
        }
        if (this.prebuilders != null) {
            for (Builder builder : this.prebuilders) {
                r.addAll(builder.getProjectActions((AbstractProject)this));
            }
        }
        if (this.postbuilders != null) {
            for (Builder builder : this.postbuilders) {
                r.addAll(builder.getProjectActions((AbstractProject)this));
            }
        }
        return r;
    }

    @Override
    protected void addTransientActionsFromBuild(MavenModuleSetBuild build, List<Action> collection, Set<Class> added) {
        if (build == null) {
            return;
        }
        for (Action a : build.getActions()) {
            if (!(a instanceof MavenAggregatedReport) || !added.add(a.getClass())) continue;
            collection.add(((MavenAggregatedReport)a).getProjectAction(this));
        }
        List<MavenReporter> list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (MavenReporter step : list) {
            Action a;
            if (!added.add(step.getClass()) || (a = step.getAggregatedProjectAction(this)) == null) continue;
            collection.add(a);
        }
    }

    void onModuleDeleted(MavenModule module) {
        this.modules.remove(module.getModuleName());
    }

    public boolean hasDisabledModule() {
        for (MavenModule m : this.modules.values()) {
            if (!m.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public List<MavenModule> getDisabledModules(boolean disabled) {
        if (!disabled && this.sortedActiveModules != null) {
            return this.sortedActiveModules;
        }
        ArrayList<MavenModule> r = new ArrayList<MavenModule>();
        for (MavenModule m : this.modules.values()) {
            if (m.isDisabled() != disabled) continue;
            r.add(m);
        }
        return r;
    }

    public Indenter<MavenModule> createIndenter() {
        return new Indenter<MavenModule>(){

            protected int getNestLevel(MavenModule job) {
                return job.nestLevel;
            }
        };
    }

    public boolean isIncrementalBuild() {
        return this.incrementalBuild;
    }

    public boolean isAggregatorStyleBuild() {
        return this.aggregatorStyleBuild;
    }

    public boolean usesPrivateRepository() {
        return !(this.getLocalRepository() instanceof DefaultLocalRepositoryLocator);
    }

    @Deprecated
    public boolean isPerModuleEmail() {
        MavenMailer m = (MavenMailer)this.reporters.get(MavenMailer.class);
        return m != null ? m.perModuleEmail : true;
    }

    public boolean ignoreUpstremChanges() {
        return this.ignoreUpstremChanges;
    }

    public boolean ignoreUnsuccessfulUpstreams() {
        return this.ignoreUnsuccessfulUpstreams;
    }

    public boolean runHeadless() {
        return this.runHeadless;
    }

    public boolean isArchivingDisabled() {
        return this.archivingDisabled;
    }

    public boolean isSiteArchivingDisabled() {
        return this.siteArchivingDisabled;
    }

    public boolean isFingerprintingDisabled() {
        return this.fingerprintingDisabled;
    }

    public void setIncrementalBuild(boolean incrementalBuild) {
        this.incrementalBuild = incrementalBuild;
    }

    public void setAggregatorStyleBuild(boolean aggregatorStyleBuild) {
        this.aggregatorStyleBuild = aggregatorStyleBuild;
    }

    public void setUsePrivateRepository(boolean usePrivateRepository) {
        this.setLocalRepository(usePrivateRepository ? new PerJobLocalRepositoryLocator() : new DefaultLocalRepositoryLocator());
    }

    public LocalRepositoryLocator getLocalRepository() {
        return this.localRepository != null ? this.localRepository : this.getDescriptor().getLocalRepository();
    }

    public LocalRepositoryLocator getExplicitLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(LocalRepositoryLocator localRepository) {
        this.localRepository = localRepository;
    }

    public void setSettings(SettingsProvider settings) {
        this.settings = settings;
    }

    public void setGlobalSettings(GlobalSettingsProvider globalSettings) {
        this.globalSettings = globalSettings;
    }

    public void setIgnoreUpstremChanges(boolean ignoreUpstremChanges) {
        this.ignoreUpstremChanges = ignoreUpstremChanges;
    }

    public void setIgnoreUnsuccessfulUpstreams(boolean ignoreUnsuccessfulUpstreams) {
        this.ignoreUnsuccessfulUpstreams = ignoreUnsuccessfulUpstreams;
    }

    public void setRunHeadless(boolean runHeadless) {
        this.runHeadless = runHeadless;
    }

    public void setIsArchivingDisabled(boolean archivingDisabled) {
        this.archivingDisabled = archivingDisabled;
    }

    public void setIsSiteArchivingDisabled(boolean siteArchivingDisabled) {
        this.siteArchivingDisabled = siteArchivingDisabled;
    }

    public void setIsFingerprintingDisabled(boolean fingerprintingDisabled) {
        this.fingerprintingDisabled = fingerprintingDisabled;
    }

    public boolean isResolveDependencies() {
        return this.resolveDependencies;
    }

    public void setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
    }

    public boolean isProcessPlugins() {
        return this.processPlugins;
    }

    public void setProcessPlugins(boolean processPlugins) {
        this.processPlugins = processPlugins;
    }

    public int getMavenValidationLevel() {
        return this.mavenValidationLevel;
    }

    public SettingsProvider getSettings() {
        return this.settings != null ? this.settings : GlobalMavenConfig.get().getSettingsProvider();
    }

    public GlobalSettingsProvider getGlobalSettings() {
        return this.globalSettings != null ? this.globalSettings : GlobalMavenConfig.get().getGlobalSettingsProvider();
    }

    public DescribableList<MavenReporter, Descriptor<MavenReporter>> getReporters() {
        return this.reporters;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishers() {
        return this.publishers;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.publishers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.buildWrappers;
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappers() {
        return this.buildWrappers;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (ModuleName.isValid(token)) {
            return this.getModule(token);
        }
        return super.getDynamic(token, req, rsp);
    }

    public File getRootDirFor(MavenModule child) {
        return new File(this.getModulesDir(), child.getModuleName().toFileSystemName());
    }

    public void onRenamed(MavenModule item, String oldName, String newName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void onDeleted(MavenModule item) throws IOException {
    }

    public Collection<Job> getAllJobs() {
        HashSet<MavenModule> jobs = new HashSet<MavenModule>(this.getItems());
        jobs.add((MavenModule)((Object)this));
        return jobs;
    }

    protected Class<MavenModuleSetBuild> getBuildClass() {
        return MavenModuleSetBuild.class;
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new CollectionSearchIndex<MavenModule>(){

            protected MavenModule get(String key) {
                if (MavenModuleSet.this.modules.values() == null) {
                    return null;
                }
                for (MavenModule m : MavenModuleSet.this.modules.values()) {
                    if (!StringUtils.equals((String)m.getDisplayName(), (String)key)) continue;
                    return m;
                }
                return null;
            }

            protected Collection<MavenModule> all() {
                return MavenModuleSet.this.modules.values();
            }

            protected String getName(MavenModule o) {
                return o.getName();
            }
        });
    }

    public boolean isFingerprintConfigured() {
        return !this.isFingerprintingDisabled() || this.getPublishersList().get(Fingerprinter.class) != null;
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.modules = Collections.emptyMap();
        super.onLoad(parent, name);
        this.modules = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getModulesDir(), (Function1)new Function1<ModuleName, MavenModule>(){

            public ModuleName call(MavenModule module) {
                return module.getModuleName();
            }
        });
        MavenModule root = this.getRootModule();
        if (root != null && root.getChildren() != null) {
            ArrayList<MavenModule> sortedList = new ArrayList<MavenModule>();
            Stack<MavenModule> q = new Stack<MavenModule>();
            root.nestLevel = 0;
            q.push(root);
            while (!q.isEmpty()) {
                MavenModule p = (MavenModule)((Object)q.pop());
                sortedList.add(p);
                List<MavenModule> children = p.getChildren();
                if (children == null) continue;
                for (MavenModule m : children) {
                    m.nestLevel = p.nestLevel + 1;
                }
                for (int i = children.size() - 1; i >= 0; --i) {
                    MavenModule item = children.get(i);
                    if (!sortedList.contains((Object)item)) {
                        q.push(item);
                        continue;
                    }
                    LOGGER.log(Level.SEVERE, "Maven project " + name + " already contains a module called " + item.getName());
                }
            }
            this.sortedActiveModules = sortedList;
        } else {
            this.sortedActiveModules = this.getDisabledModules(false);
        }
        if (this.reporters == null) {
            this.reporters = new DescribableList((Saveable)this);
        }
        this.reporters.setOwner((Saveable)this);
        if (this.publishers == null) {
            this.publishers = new DescribableList((Saveable)this);
        }
        this.publishers.setOwner((Saveable)this);
        if (this.buildWrappers == null) {
            this.buildWrappers = new DescribableList((Saveable)this);
        }
        this.buildWrappers.setOwner((Saveable)this);
        if (this.prebuilders == null) {
            this.prebuilders = new DescribableList((Saveable)this);
        }
        this.prebuilders.setOwner((Saveable)this);
        if (this.postbuilders == null) {
            this.postbuilders = new DescribableList((Saveable)this);
        }
        this.postbuilders.setOwner((Saveable)this);
        if (Boolean.TRUE.equals(this.usePrivateRepository)) {
            this.localRepository = new PerJobLocalRepositoryLocator();
            this.usePrivateRepository = null;
        }
        this.updateTransientActions();
    }

    private File getModulesDir() {
        return new File(this.getRootDir(), "modules");
    }

    public synchronized int assignBuildNumber() throws IOException {
        this.updateNextBuildNumber();
        return super.assignBuildNumber();
    }

    public void logRotate() throws IOException, InterruptedException {
        super.logRotate();
        for (MavenModule m : this.modules.values()) {
            m.logRotate();
        }
    }

    void updateNextBuildNumber() throws IOException {
        int next = this.nextBuildNumber;
        for (MavenModule m : this.modules.values()) {
            next = Math.max(next, m.getNextBuildNumber());
        }
        if (this.nextBuildNumber != next) {
            this.nextBuildNumber = next;
            this.saveNextBuildNumber();
        }
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        super.buildDependencyGraph(graph);
        this.publishers.buildDependencyGraph((AbstractProject)this, graph);
        this.buildWrappers.buildDependencyGraph((AbstractProject)this, graph);
        this.prebuilders.buildDependencyGraph((AbstractProject)this, graph);
        this.postbuilders.buildDependencyGraph((AbstractProject)this, graph);
    }

    public boolean isDisableTriggerDownstreamProjects() {
        return this.disableTriggerDownstreamProjects;
    }

    public void setDisableTriggerDownstreamProjects(boolean disableTriggerDownstreamProjects) {
        this.disableTriggerDownstreamProjects = disableTriggerDownstreamProjects;
    }

    public boolean getBlockTriggerWhenBuilding() {
        return this.blockTriggerWhenBuilding == null || this.blockTriggerWhenBuilding != false;
    }

    public void setBlockTriggerWhenBuilding(boolean blockTriggerWhenBuilding) {
        this.blockTriggerWhenBuilding = blockTriggerWhenBuilding;
    }

    public MavenModule getRootModule() {
        if (this.rootModule == null) {
            return null;
        }
        return this.modules.get(this.rootModule);
    }

    public Maven.MavenInstallation inferMavenInstallation() {
        return this.getMaven();
    }

    protected Set<ResourceActivity> getResourceActivities() {
        HashSet<ResourceActivity> activities = new HashSet<ResourceActivity>();
        activities.addAll(super.getResourceActivities());
        activities.addAll(Util.filter(this.publishers, ResourceActivity.class));
        activities.addAll(Util.filter(this.buildWrappers, ResourceActivity.class));
        activities.addAll(Util.filter(this.prebuilders, ResourceActivity.class));
        activities.addAll(Util.filter(this.postbuilders, ResourceActivity.class));
        return activities;
    }

    public String getRootPOM() {
        return this.getRootPOM(null);
    }

    public String getRootPOM(EnvVars env) {
        if (this.rootPOM == null) {
            return "pom.xml";
        }
        if (env == null) {
            return this.rootPOM;
        }
        return env.expand(this.rootPOM);
    }

    public void setRootPOM(String rootPOM) {
        this.rootPOM = rootPOM;
    }

    public AbstractProject<?, ?> asProject() {
        return this;
    }

    public String getGoals() {
        if (this.goals == null) {
            if (this.defaultGoals != null) {
                return this.defaultGoals;
            }
            return "install";
        }
        return this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    private boolean checkMavenOption(String shortForm, String longForm) {
        for (String t : Util.tokenize((String)this.getGoals())) {
            if (!t.equals(shortForm) && !t.equals(longForm)) continue;
            return true;
        }
        return false;
    }

    private List<String> getMavenArgument(String shortForm, String longForm) {
        ArrayList<String> args = new ArrayList<String>();
        boolean switchFound = false;
        for (String t : Util.tokenize((String)this.getGoals())) {
            if (switchFound) {
                args.add(t);
                switchFound = false;
                continue;
            }
            if (t.equals(shortForm) || t.equals(longForm)) {
                switchFound = true;
                continue;
            }
            if (t.startsWith(shortForm)) {
                args.add(t.substring(shortForm.length()));
                continue;
            }
            if (!t.startsWith(longForm)) continue;
            args.add(t.substring(longForm.length()));
        }
        return args;
    }

    public String getAlternateSettings() {
        return this.alternateSettings;
    }

    public void setAlternateSettings(String alternateSettings) throws IOException {
        this.alternateSettings = alternateSettings;
    }

    public String getProfiles() {
        return Util.join(this.getMavenArgument("-P", "--activate-profiles"), (String)",");
    }

    public Properties getMavenProperties() {
        Properties props = new Properties();
        for (String arg : this.getMavenArgument("-D", "--define")) {
            int idx = arg.indexOf(61);
            if (idx < 0) {
                props.put(arg, "true");
                continue;
            }
            props.put(arg.substring(0, idx), arg.substring(idx + 1));
        }
        return props;
    }

    public boolean isNonRecursive() {
        return this.checkMavenOption("-N", "--non-recursive");
    }

    public String getMavenOpts() {
        if (this.mavenOpts != null && this.mavenOpts.trim().length() > 0) {
            return this.getFormattedMavenOpts(this.mavenOpts);
        }
        String globalOpts = this.getDescriptor().getGlobalMavenOpts();
        if (globalOpts != null) {
            return this.getFormattedMavenOpts(globalOpts);
        }
        return globalOpts;
    }

    private String getFormattedMavenOpts(String mavenOpts) {
        return mavenOpts == null ? null : mavenOpts.replaceAll("[\t\r\n]+", " ");
    }

    public void setMavenOpts(String mavenOpts) {
        String globalMavenOpts = this.getFormattedMavenOpts(this.getDescriptor().getGlobalMavenOpts());
        this.mavenOpts = mavenOpts != null && !this.getFormattedMavenOpts(mavenOpts).equals(globalMavenOpts) ? mavenOpts : null;
    }

    public Maven.MavenInstallation getMaven() {
        Maven.MavenInstallation[] installations;
        for (Maven.MavenInstallation i : installations = this.getDescriptor().getMavenDescriptor().getInstallations()) {
            if (this.mavenName != null && !i.getName().equals(this.mavenName)) continue;
            return i;
        }
        if (installations.length == 1) {
            return installations[0];
        }
        return null;
    }

    public void setMaven(String mavenName) {
        this.mavenName = mavenName;
    }

    public List<Queue.Item> getQueueItems() {
        return this.filter(Arrays.asList(Jenkins.getInstance().getQueue().getItems()));
    }

    public List<Queue.Item> getApproximateQueueItemsQuickly() {
        return this.filter(Jenkins.getInstance().getQueue().getApproximateItemsQuickly());
    }

    private List<Queue.Item> filter(Collection<Queue.Item> base) {
        ArrayList<Queue.Item> r = new ArrayList<Queue.Item>();
        for (Queue.Item item : base) {
            Queue.Task t = item.task;
            if ((!(t instanceof MavenModule) || ((MavenModule)t).getParent() != this) && t != this) continue;
            r.add(item);
        }
        return r;
    }

    public String getUserConfiguredGoals() {
        return this.goals;
    }

    protected List<MavenModuleSetBuild> getEstimatedDurationCandidates() {
        return super.getEstimatedDurationCandidates();
    }

    void reconfigure(PomInfo rootPom) throws IOException {
        if (this.rootModule != null && this.rootModule.equals(rootPom.name)) {
            return;
        }
        this.rootModule = rootPom.name;
        this.defaultGoals = rootPom.defaultGoal;
        this.save();
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        JSONObject ignoreUpstremChangesConfig;
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.rootPOM = Util.fixEmpty((String)req.getParameter("rootPOM").trim());
        if (this.rootPOM != null && this.rootPOM.equals("pom.xml")) {
            this.rootPOM = null;
        }
        this.goals = Util.fixEmpty((String)req.getParameter("goals").trim());
        this.setMavenOpts(Util.fixEmpty((String)req.getParameter("mavenOpts").trim()));
        this.settings = SettingsProvider.parseSettingsProvider((StaplerRequest)req);
        this.globalSettings = GlobalSettingsProvider.parseSettingsProvider((StaplerRequest)req);
        this.mavenName = req.getParameter("maven_version");
        this.aggregatorStyleBuild = !req.hasParameter("maven.perModuleBuild");
        this.localRepository = json.optBoolean("usePrivateRepository") ? (LocalRepositoryLocator)((Object)req.bindJSON(LocalRepositoryLocator.class, json.getJSONObject("explicitLocalRepository"))) : null;
        boolean bl = this.ignoreUpstremChanges = !json.has("triggerByDependency");
        this.ignoreUnsuccessfulUpstreams = !this.ignoreUpstremChanges ? null != (ignoreUpstremChangesConfig = json.optJSONObject("triggerByDependency")) && ignoreUpstremChangesConfig.has("ignoreUnsuccessfulUpstreams") : false;
        this.runHeadless = req.hasParameter("maven.runHeadless");
        this.incrementalBuild = req.hasParameter("maven.incrementalBuild");
        this.archivingDisabled = req.hasParameter("maven.archivingDisabled");
        this.siteArchivingDisabled = req.hasParameter("maven.siteArchivingDisabled");
        this.fingerprintingDisabled = req.hasParameter("maven.fingerprintingDisabled");
        this.resolveDependencies = req.hasParameter("maven.resolveDependencies");
        this.processPlugins = req.hasParameter("maven.processPlugins");
        this.mavenValidationLevel = NumberUtils.toInt((String)req.getParameter("maven.validationLevel"), (int)-1);
        this.reporters.rebuild(req, json, MavenReporters.getConfigurableList());
        this.publishers.rebuildHetero(req, json, (Collection)Publisher.all(), "publisher");
        this.buildWrappers.rebuild(req, json, BuildWrappers.getFor((AbstractProject)this));
        JSONObject enableTriggerDownstreamProjects = json.optJSONObject("enableTriggerDownstreamProjects");
        if (enableTriggerDownstreamProjects == null) {
            this.disableTriggerDownstreamProjects = true;
            this.blockTriggerWhenBuilding = null;
        } else {
            this.disableTriggerDownstreamProjects = false;
            this.blockTriggerWhenBuilding = enableTriggerDownstreamProjects.has("blockTriggerWhenBuilding");
        }
        this.runPostStepsIfResult = Result.fromString((String)req.getParameter("post-steps.runIfResult"));
        this.prebuilders.rebuildHetero(req, json, (Collection)Builder.all(), "prebuilder");
        this.postbuilders.rebuildHetero(req, json, (Collection)Builder.all(), "postbuilder");
    }

    public HttpResponse doDoDeleteAllDisabledModules() throws IOException, InterruptedException {
        this.checkPermission(DELETE);
        for (MavenModule m : this.getDisabledModules(true)) {
            m.delete();
        }
        return HttpResponses.redirectToDot();
    }

    public AbstractTestResultAction<?> getTestResultAction() {
        MavenModuleSetBuild b = (MavenModuleSetBuild)this.getLastBuild();
        return b != null ? (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class) : null;
    }

    public FormValidation doCheckFileInWorkspace(@QueryParameter String value) throws IOException, ServletException {
        FilePath ws;
        MavenModuleSetBuild lb = (MavenModuleSetBuild)this.getLastBuild();
        if (lb != null && (ws = lb.getModuleRoot()) != null) {
            return ws.validateRelativePath(value, true, true);
        }
        return FormValidation.ok();
    }

    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (MavenModule mm : this.getModules()) {
            menu.add((Job)mm);
        }
        return menu;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public static final class DescriptorImpl
    extends AbstractProject.AbstractProjectDescriptor
    implements IconSpec {
        private String globalMavenOpts;
        private Map<String, Integer> mavenValidationLevels = new LinkedHashMap<String, Integer>();
        private LocalRepositoryLocator localRepository = new DefaultLocalRepositoryLocator();
        private static final Set<Class> NOT_APPLICABLE_TYPES = new HashSet<Class>(Arrays.asList(JavadocArchiver.class, Mailer.class, JUnitResultArchiver.class));

        public DescriptorImpl() {
            this.load();
            this.mavenValidationLevels.put("DEFAULT", -1);
            this.mavenValidationLevels.put("LEVEL_MINIMAL", 0);
            this.mavenValidationLevels.put("LEVEL_MAVEN_2_0", 20);
            this.mavenValidationLevels.put("LEVEL_MAVEN_3_0", 30);
            this.mavenValidationLevels.put("LEVEL_MAVEN_3_1", 31);
            this.mavenValidationLevels.put("LEVEL_STRICT", 30);
        }

        public String getHelpFile(String fieldName) {
            String v = super.getHelpFile(fieldName);
            if (v != null) {
                return v;
            }
            if (fieldName == null) {
                return null;
            }
            return Jenkins.getInstance().getDescriptor(Maven.class).getHelpFile(fieldName);
        }

        public List<SettingsProviderDescriptor> getSettingsProviders() {
            return Jenkins.getInstance().getDescriptorList(SettingsProvider.class);
        }

        public List<GlobalSettingsProviderDescriptor> getGlobalSettingsProviders() {
            return Jenkins.getInstance().getDescriptorList(GlobalSettingsProvider.class);
        }

        public String getGlobalMavenOpts() {
            return this.globalMavenOpts;
        }

        public void setGlobalMavenOpts(String globalMavenOpts) {
            this.globalMavenOpts = globalMavenOpts;
            this.save();
        }

        public LocalRepositoryLocator getLocalRepository() {
            return this.localRepository != null ? this.localRepository : new DefaultLocalRepositoryLocator();
        }

        public void setLocalRepository(LocalRepositoryLocator localRepository) {
            this.localRepository = localRepository;
            this.save();
        }

        public String getDisplayName() {
            return Messages.MavenModuleSet_DiplayName();
        }

        public String getCategoryId() {
            return "standalone-projects";
        }

        public String getDescription() {
            return Messages.MavenModuleSet_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/maven-plugin/images/:size/mavenmoduleset.png";
        }

        public String getIconClassName() {
            return "icon-maven-moduleset";
        }

        public MavenModuleSet newInstance(ItemGroup parent, String name) {
            MavenModuleSet mms = new MavenModuleSet(parent, name);
            mms.setSettings(GlobalMavenConfig.get().getSettingsProvider());
            mms.setGlobalSettings(GlobalMavenConfig.get().getGlobalSettingsProvider());
            return mms;
        }

        public Maven.DescriptorImpl getMavenDescriptor() {
            return (Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class);
        }

        public Map<String, Integer> getMavenValidationLevels() {
            return this.mavenValidationLevels;
        }

        public boolean configure(StaplerRequest req, JSONObject o) {
            this.globalMavenOpts = Util.fixEmptyAndTrim((String)o.getString("globalMavenOpts"));
            this.localRepository = (LocalRepositoryLocator)((Object)req.bindJSON(LocalRepositoryLocator.class, o.getJSONObject("localRepository")));
            this.save();
            return true;
        }

        public boolean isApplicable(Descriptor descriptor) {
            return !NOT_APPLICABLE_TYPES.contains(descriptor.clazz);
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-maven-moduleset icon-sm", "plugin/maven-plugin/images/16x16/mavenmoduleset.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-maven-moduleset icon-md", "plugin/maven-plugin/images/24x24/mavenmoduleset.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-maven-moduleset icon-lg", "plugin/maven-plugin/images/32x32/mavenmoduleset.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-maven-moduleset icon-xlg", "plugin/maven-plugin/images/48x48/mavenmoduleset.png", "width: 48px; height: 48px;"));
        }
    }
}

