/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.FilePath;
import hudson.remoting.Channel;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class PlexusModuleContributor
implements Serializable {
    protected transient Channel channel;
    private static final long serialVersionUID = 1L;

    public abstract List<URL> getPlexusComponentJars();

    protected Object readResolve() {
        this.channel = Channel.current();
        return this;
    }

    public static PlexusModuleContributor of(FilePath ... jars) {
        return PlexusModuleContributor.of(Arrays.asList(jars));
    }

    public static PlexusModuleContributor of(List<FilePath> jars) {
        ArrayList<String> files = new ArrayList<String>(jars.size());
        for (FilePath jar : jars) {
            files.add(jar.getRemote());
        }
        return new PlexusModuleContributorOfPaths(files);
    }

    private static class PlexusModuleContributorOfPaths
    extends PlexusModuleContributor {
        private static final long serialVersionUID = 8528727996575052850L;
        private List<String> files;

        public PlexusModuleContributorOfPaths(List<String> files) {
            this.files = files;
        }

        @Override
        public List<URL> getPlexusComponentJars() {
            try {
                ArrayList<URL> r = new ArrayList<URL>(this.files.size());
                for (String file : this.files) {
                    r.add(new File(file).toURI().toURL());
                }
                return r;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

