/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.maven.Maven3Builder;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenModule;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.maven.reporters.SurefireReport;
import hudson.maven.reporters.TestFailureDetector;
import hudson.maven.reporters.TestMojo;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SurefireArchiver
extends TestFailureDetector {
    private transient TestResult result;
    private final AtomicBoolean hasTestFailures = new AtomicBoolean();
    private transient ConcurrentMap<File, Long> parsedFiles = new ConcurrentHashMap<File, Long>();
    private static final long serialVersionUID = 1L;

    @Override
    public boolean hasTestFailures() {
        return this.hasTestFailures.get();
    }

    @Override
    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        XmlPlexusConfiguration c;
        if (this.isTestMojo(mojo) && (c = (XmlPlexusConfiguration)mojo.configuration.getChild("testFailureIgnore", false)) != null && c.getValue() != null && c.getValue().equals("${maven.test.failure.ignore}") && System.getProperty("maven.test.failure.ignore") == null) {
            if (build.getMavenBuildInformation().isMaven3OrLater()) {
                String fieldName = "testFailureIgnore";
                if (mojo.mojoExecution.getConfiguration().getChild(fieldName) != null) {
                    mojo.mojoExecution.getConfiguration().getChild(fieldName).setValue(Boolean.TRUE.toString());
                } else {
                    Xpp3Dom child = new Xpp3Dom(fieldName);
                    child.setValue(Boolean.TRUE.toString());
                    mojo.mojoExecution.getConfiguration().addChild(child);
                }
            } else {
                c.setValue(Boolean.TRUE.toString());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, final BuildListener listener, Throwable error) throws InterruptedException, IOException {
        Iterable fileSet;
        TestMojo testMojo = this.getTestMojo(mojo);
        if (testMojo == null) {
            return true;
        }
        listener.getLogger().println(Messages.SurefireArchiver_Recording());
        try {
            fileSet = testMojo.getReportFiles(pom, mojo);
        }
        catch (ComponentConfigurationException e) {
            e.printStackTrace(listener.fatalError(Messages.SurefireArchiver_NoReportsDir()));
            build.setResult(Result.FAILURE);
            return true;
        }
        if (fileSet != null) {
            MavenBuildProxy mavenBuildProxy = build;
            synchronized (mavenBuildProxy) {
                if (this.result == null) {
                    this.result = new TestResult();
                }
                if (!(fileSet = Iterables.filter(fileSet, (Predicate)new Predicate<File>(){

                    public boolean apply(File input) {
                        return !SurefireArchiver.this.parsedFiles.containsKey(input) || ((Long)SurefireArchiver.this.parsedFiles.get(input)).longValue() != input.lastModified();
                    }
                })).iterator().hasNext()) {
                    return true;
                }
                this.result.parse(System.currentTimeMillis() - build.getMilliSecsSinceBuildStart(), fileSet);
                this.rememberCheckedFiles(fileSet);
                final TestResult r = this.result;
                int failCount = build.execute(new MavenBuildProxy.BuildCallable<Integer, IOException>(){
                    private static final long serialVersionUID = -1023888330720922136L;

                    @Override
                    public Integer call(MavenBuild build) throws IOException, InterruptedException {
                        SurefireReport sr = (SurefireReport)build.getAction(SurefireReport.class);
                        if (sr == null) {
                            build.getActions().add(new SurefireReport(build, r, listener));
                        } else {
                            sr.setResult(r, listener);
                        }
                        if (r.getFailCount() > 0) {
                            build.setResult(Result.UNSTABLE);
                        }
                        build.registerAsProjectAction(new FactoryImpl());
                        return r.getFailCount();
                    }
                });
                if (failCount > 0) {
                    this.markBuildAsSuccess(error, build.getMavenBuildInformation());
                    this.hasTestFailures.set(true);
                }
            }
        }
        return true;
    }

    @Override
    public boolean end(MavenBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (MavenReporter reporter : ((MavenModule)build.getProject()).getReporters()) {
            if (!(reporter instanceof SurefireArchiver)) continue;
            SurefireArchiver surefireReporter = (SurefireArchiver)reporter;
            if (surefireReporter.result == null) continue;
            surefireReporter.result = null;
        }
        return true;
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="It's okay to write to static fields here, as each Maven build is started in its own VM")
    private void markBuildAsSuccess(Throwable mojoError, MavenBuildInformation buildInfo) {
        if (mojoError == null || mojoError instanceof MojoFailureException) {
            MavenBuilder.markAsSuccess = true;
            Maven3Builder.markAsSuccess = true;
        }
    }

    private void rememberCheckedFiles(Iterable<File> fileSet) {
        for (File f : fileSet) {
            this.parsedFiles.put(f, f.lastModified());
        }
    }

    public static void fixUp(List<MavenProjectActionBuilder> builders) {
        if (builders == null) {
            return;
        }
        ListIterator<MavenProjectActionBuilder> itr = builders.listIterator();
        while (itr.hasNext()) {
            MavenProjectActionBuilder b = itr.next();
            if (!(b instanceof SurefireArchiver)) continue;
            itr.set(new FactoryImpl());
        }
    }

    boolean isTestMojo(MojoInfo mojo) {
        return this.getTestMojo(mojo) != null;
    }

    private TestMojo getTestMojo(MojoInfo mojo) {
        TestMojo testMojo = TestMojo.lookup(mojo);
        if (testMojo == null) {
            return null;
        }
        try {
            String[] skipProperties;
            for (String skipProperty : skipProperties = new String[]{"skip", "skipExec", "skipTests", "skipTest"}) {
                Boolean skip = mojo.getConfigurationValue(skipProperty, Boolean.class);
                if (skip == null || !skip.booleanValue()) continue;
                return null;
            }
        }
        catch (ComponentConfigurationException e) {
            return null;
        }
        return testMojo;
    }

    protected Object readResolve() {
        this.parsedFiles = new ConcurrentHashMap<File, Long>();
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.SurefireArchiver_DisplayName();
        }

        @Override
        public SurefireArchiver newAutoInstance(MavenModule module) {
            return new SurefireArchiver();
        }
    }

    static final class FactoryImpl
    implements MavenProjectActionBuilder {
        FactoryImpl() {
        }

        @Override
        public Collection<? extends Action> getProjectActions(MavenModule module) {
            return Collections.singleton(new TestResultProjectAction((AbstractProject)module));
        }
    }

    static class FilteredReportsFileIterable
    implements Iterable<File> {
        private final File reportsDir;
        private final String[] reportFiles;
        private final long from;
        private final long to;

        FilteredReportsFileIterable(File reportsDir, String[] reportFiles, long from, long to) {
            this.reportsDir = reportsDir;
            this.reportFiles = reportFiles;
            this.from = from - 2000L;
            this.to = to + 2000L;
        }

        @Override
        public Iterator<File> iterator() {
            Predicate<File> fileWithinFromAndTo = new Predicate<File>(){

                public boolean apply(File file) {
                    long lastModified = file.lastModified();
                    return lastModified >= FilteredReportsFileIterable.this.from && lastModified <= FilteredReportsFileIterable.this.to;
                }
            };
            return Iterators.filter((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])this.reportFiles), (Function)new Function<String, File>(){

                public File apply(String file) {
                    return FilteredReportsFileIterable.this.getFile(FilteredReportsFileIterable.this.reportsDir, file);
                }
            }), (Predicate)fileWithinFromAndTo);
        }

        File getFile(File parent, String child) {
            return new File(parent, child);
        }
    }
}

