/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.BuildTimeoutWrapper;
import hudson.plugins.build_timeout.impl.Messages;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.DataBoundConstructor;

public class ElasticTimeOutStrategy
extends BuildTimeOutStrategy {
    private final String timeoutPercentage;
    private final String numberOfBuilds;
    private final boolean failSafeTimeoutDuration;
    private final String timeoutMinutesElasticDefault;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public String getTimeoutPercentage() {
        return this.timeoutPercentage;
    }

    public String getNumberOfBuilds() {
        return this.numberOfBuilds;
    }

    public String getTimeoutMinutesElasticDefault() {
        return this.timeoutMinutesElasticDefault;
    }

    public boolean isFailSafeTimeoutDuration() {
        return this.failSafeTimeoutDuration;
    }

    @Deprecated
    public ElasticTimeOutStrategy(int timeoutPercentage, int timeoutMinutesElasticDefault, int numberOfBuilds) {
        this(Integer.toString(timeoutPercentage), Integer.toString(timeoutMinutesElasticDefault), Integer.toString(numberOfBuilds), false);
    }

    @Deprecated
    public ElasticTimeOutStrategy(String timeoutPercentage, String timeoutMinutesElasticDefault, String numberOfBuilds) {
        this(timeoutPercentage, timeoutMinutesElasticDefault, numberOfBuilds, false);
    }

    @DataBoundConstructor
    public ElasticTimeOutStrategy(String timeoutPercentage, String timeoutMinutesElasticDefault, String numberOfBuilds, boolean failSafeTimeoutDuration) {
        this.timeoutPercentage = timeoutPercentage;
        this.timeoutMinutesElasticDefault = timeoutMinutesElasticDefault;
        this.numberOfBuilds = numberOfBuilds;
        this.failSafeTimeoutDuration = failSafeTimeoutDuration;
    }

    @Override
    public long getTimeOut(@Nonnull AbstractBuild<?, ?> build, @Nonnull BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException {
        double elasticTimeout = this.getElasticTimeout(Integer.parseInt(this.expandAll(build, listener, this.getTimeoutPercentage())), build, listener);
        if (elasticTimeout == 0.0) {
            return Math.max(BuildTimeoutWrapper.MINIMUM_TIMEOUT_MILLISECONDS, (long)Integer.parseInt(this.expandAll(build, listener, this.getTimeoutMinutesElasticDefault())) * 60000L);
        }
        if (this.isFailSafeTimeoutDuration()) {
            return Math.max((long)Integer.parseInt(this.expandAll(build, listener, this.getTimeoutMinutesElasticDefault())) * 60000L, (long)elasticTimeout);
        }
        return (long)Math.max((double)BuildTimeoutWrapper.MINIMUM_TIMEOUT_MILLISECONDS, elasticTimeout);
    }

    private double getElasticTimeout(int timeoutPercentage, @Nonnull AbstractBuild<?, ?> build, @Nonnull BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException {
        return (double)timeoutPercentage * 0.01 * (timeoutPercentage > 0 ? this.averageDuration(build, listener) : 0.0);
    }

    private double averageDuration(@Nonnull AbstractBuild<?, ?> build, @Nonnull BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException {
        int nonFailingBuilds = 0;
        int durationSum = 0;
        int numberOfBuilds = Integer.parseInt(this.expandAll(build, listener, this.getNumberOfBuilds()));
        while (build != null && build.getPreviousBuild() != null && nonFailingBuilds < numberOfBuilds) {
            if ((build = build.getPreviousBuild()) == null || build.getResult() == null || !build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) continue;
            durationSum = (int)((long)durationSum + build.getDuration());
            ++nonFailingBuilds;
        }
        return nonFailingBuilds > 0 ? (double)durationSum / (double)nonFailingBuilds : 0.0;
    }

    @Override
    public Descriptor<BuildTimeOutStrategy> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends BuildTimeOutStrategyDescriptor {
        public String getDisplayName() {
            return Messages.ElasticTimeOutStrategy_DisplayName();
        }

        public int[] getPercentages() {
            return new int[]{150, 200, 250, 300, 350, 400};
        }

        public ListBoxModel doFillTimeoutPercentageItems() {
            ListBoxModel m = new ListBoxModel();
            for (int option : this.getPercentages()) {
                String s = String.valueOf(option);
                m.add(s + "%", s);
            }
            return m;
        }
    }
}

