/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.operations;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.BuildTimeOutUtility;
import hudson.plugins.build_timeout.operations.Messages;
import hudson.remoting.Channel;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BuildStepOperation
extends BuildTimeOutOperation {
    private final BuildStep buildstep;
    private final boolean continueEvenFailed;
    private final boolean createLauncher;

    public BuildStep getBuildstep() {
        return this.buildstep;
    }

    public boolean isContinueEvenFailed() {
        return this.continueEvenFailed;
    }

    public boolean isCreateLauncher() {
        return this.createLauncher;
    }

    @DataBoundConstructor
    public BuildStepOperation(BuildStep buildstep, boolean continueEvenFailed, boolean createLauncher) {
        this.buildstep = buildstep;
        this.continueEvenFailed = continueEvenFailed;
        this.createLauncher = createLauncher;
    }

    @Deprecated
    public BuildStepOperation(BuildStep buildstep, boolean continueEvenFailed) {
        this(buildstep, continueEvenFailed, false);
    }

    protected Launcher createLauncher(@Nonnull AbstractBuild<?, ?> build, @Nonnull BuildListener listener) {
        if (!this.isCreateLauncher()) {
            return new DummyLauncher();
        }
        Node builtOn = build.getBuiltOn();
        if (builtOn == null) {
            throw new IllegalStateException("current build's builtOn is null");
        }
        Launcher l = builtOn.createLauncher((TaskListener)listener);
        if (build.getParent() instanceof BuildableItemWithBuildWrappers) {
            BuildableItemWithBuildWrappers biwbw = (BuildableItemWithBuildWrappers)build.getParent();
            for (BuildWrapper bw : biwbw.getBuildWrappersList()) {
                try {
                    l = bw.decorateLauncher(build, l, listener);
                }
                catch (Run.RunnerAbortedException | IOException | InterruptedException e) {
                    e.printStackTrace(listener.getLogger());
                }
            }
        }
        return l;
    }

    @Override
    public boolean perform(@Nonnull AbstractBuild<?, ?> build, @Nonnull BuildListener listener, long effectiveTimeout) {
        boolean result;
        try {
            result = this.getBuildstep().perform(build, this.createLauncher(build, listener), listener);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(listener.getLogger());
            result = false;
        }
        return this.isContinueEvenFailed() || result;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTimeOutOperationDescriptor {
        private boolean enabled = false;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setEnabled(json.containsKey((Object)"enabled"));
            this.save();
            return true;
        }

        public BuildStepOperation newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            BuildStep buildstep = BuildTimeOutUtility.bindJSONWithDescriptor(req, formData, "buildstep", BuildStep.class);
            boolean continueEvenFailed = formData.getBoolean("continueEvenFailed");
            boolean createLauncher = formData.getBoolean("createLauncher");
            return new BuildStepOperation(buildstep, continueEvenFailed, createLauncher);
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject<?, ?>> jobType) {
            return this.isEnabled();
        }

        public String getDisplayName() {
            return Messages.BuildStepOperation_DisplayName();
        }

        public List<Descriptor<?>> getBuildStepDescriptors(AbstractProject<?, ?> project) {
            ArrayList buildsteps = new ArrayList();
            buildsteps.addAll(BuildStepDescriptor.filter((List)Builder.all(), project.getClass()));
            buildsteps.addAll(BuildStepDescriptor.filter((List)Publisher.all(), project.getClass()));
            return buildsteps;
        }
    }

    private static class DummyLauncher
    extends Launcher {
        public DummyLauncher() {
            super(null, null);
        }

        public void kill(Map<String, String> arg0) throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Launcher does not supported in BuildStep timeout operation");
        }

        public Proc launch(Launcher.ProcStarter arg0) throws IOException {
            throw new UnsupportedOperationException("Launcher does not supported in BuildStep timeout operation");
        }

        public Channel launchChannel(String[] arg0, OutputStream arg1, FilePath arg2, Map<String, String> arg3) throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Launcher does not supported in BuildStep timeout operation");
        }
    }
}

