/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.operations;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Result;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.Messages;
import hudson.util.TimeUnit2;
import org.kohsuke.stapler.DataBoundConstructor;

public class FailOperation
extends BuildTimeOutOperation {
    @DataBoundConstructor
    public FailOperation() {
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, BuildListener listener, long effectiveTimeout) {
        long effectiveTimeoutMinutes = TimeUnit2.MINUTES.convert(effectiveTimeout, TimeUnit2.MILLISECONDS);
        listener.getLogger().println(Messages.Timeout_Message(effectiveTimeoutMinutes, Messages.Timeout_Failed()));
        Executor e = build.getExecutor();
        if (e != null) {
            e.interrupt(Result.FAILURE);
        }
        return true;
    }

    @Extension(ordinal=50.0)
    public static class DescriptorImpl
    extends BuildTimeOutOperationDescriptor {
        public String getDisplayName() {
            return hudson.plugins.build_timeout.operations.Messages.FailOperation_DisplayName();
        }
    }
}

