/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.CopyArtifact;
import hudson.plugins.copyartifact.Messages;
import hudson.util.XStream2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BuildSelectorParameter
extends SimpleParameterDefinition {
    private BuildSelector defaultSelector;
    private static final Logger LOGGER = Logger.getLogger(BuildSelectorParameter.class.getName());
    private static final XStream2 XSTREAM = new XStream2();

    @DataBoundConstructor
    public BuildSelectorParameter(String name, BuildSelector defaultSelector, String description) {
        super(name, description);
        this.defaultSelector = defaultSelector;
    }

    public BuildSelector getDefaultSelector() {
        return this.defaultSelector;
    }

    public ParameterValue getDefaultParameterValue() {
        return this.toStringValue(this.defaultSelector);
    }

    public ParameterValue createValue(String value) {
        BuildSelectorParameter.getSelectorFromXml(value);
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        return this.toStringValue((BuildSelector)((Object)req.bindJSON(BuildSelector.class, jo)));
    }

    private StringParameterValue toStringValue(BuildSelector selector) {
        return new StringParameterValue(this.getName(), XSTREAM.toXML((Object)selector).replaceAll("[\n\r]+", ""), this.getDescription());
    }

    public static BuildSelector getSelectorFromXml(String xml) {
        return (BuildSelector)((Object)XSTREAM.fromXML(xml));
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void initAliases() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            LOGGER.severe("Called for initialization but Jenkins instance no longer available.");
            return;
        }
        DescriptorImpl descriptor = (DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class);
        DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> descriptorList = descriptor.getBuildSelectors();
        for (Descriptor d : descriptorList) {
            XSTREAM.alias(d.clazz.getSimpleName(), d.clazz);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.BuildSelectorParameter_DisplayName();
        }

        public DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> getBuildSelectors() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return DescriptorExtensionList.createDescriptorList((Jenkins)null, BuildSelector.class);
            }
            return jenkins.getDescriptorList(BuildSelector.class);
        }

        public List<Descriptor<BuildSelector>> getAvailableBuildSelectorList() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Iterable)Collections2.filter((Collection)jenkins.getDescriptorList(BuildSelector.class), (Predicate)new Predicate<Descriptor<BuildSelector>>(){

                public boolean apply(Descriptor<BuildSelector> input) {
                    return !"ParameterizedBuildSelector".equals(input.clazz.getSimpleName());
                }
            }));
        }

        public String getHelpFile(String fieldName) {
            if ("defaultSelector".equals(fieldName) || "parameter".equals(fieldName)) {
                Descriptor d;
                Jenkins jenkins = Jenkins.getInstance();
                Descriptor descriptor = d = jenkins == null ? null : jenkins.getDescriptor(CopyArtifact.class);
                if (d != null) {
                    return d.getHelpFile("selector");
                }
            }
            return super.getHelpFile(fieldName);
        }
    }
}

