/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.diagnosis.OldDataMonitor;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Fingerprint;
import hudson.model.FingerprintMap;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.CopyArtifactPermissionProperty;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.ParametersBuildFilter;
import hudson.plugins.copyartifact.StatusBuildSelector;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.SecurityRealm;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Fingerprinter;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import hudson.util.XStream2;
import io.jenkins.plugins.httpclient.RobustHTTPClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.VirtualFile;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class CopyArtifact
extends Builder
implements SimpleBuildStep {
    private static boolean upgradeNeeded = false;
    private static Logger LOGGER = Logger.getLogger(CopyArtifact.class.getName());
    private static final BuildSelector DEFAULT_BUILD_SELECTOR = new StatusBuildSelector(true);
    @Deprecated
    private String projectName;
    private String project;
    private String parameters;
    private String filter;
    private String target;
    private String excludes;
    private BuildSelector selector;
    @Deprecated
    private transient Boolean stable;
    private Boolean flatten;
    private Boolean optional;
    private boolean doNotFingerprintArtifacts;
    private String resultVariableSuffix;

    @Deprecated
    public CopyArtifact(String projectName, String parameters, BuildSelector selector, String filter, String target, boolean flatten, boolean optional) {
        this(projectName, parameters, selector, filter, target, flatten, optional, true);
    }

    @Deprecated
    public CopyArtifact(String projectName, String parameters, BuildSelector selector, String filter, String target, boolean flatten, boolean optional, boolean fingerprintArtifacts) {
        this(projectName, parameters, selector, filter, null, target, flatten, optional, fingerprintArtifacts);
    }

    @Deprecated
    public CopyArtifact(String projectName, String parameters, BuildSelector selector, String filter, String excludes, String target, boolean flatten, boolean optional, boolean fingerprintArtifacts) {
        this(projectName);
        this.setParameters(parameters);
        this.setFilter(filter);
        this.setTarget(target);
        this.setExcludes(excludes);
        if (selector == null) {
            selector = DEFAULT_BUILD_SELECTOR;
        }
        this.setSelector(selector);
        this.setFlatten(flatten);
        this.setOptional(optional);
        this.setFingerprintArtifacts(fingerprintArtifacts);
    }

    @DataBoundConstructor
    public CopyArtifact(String projectName) {
        AbstractProject p;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && (p = (AbstractProject)req.findAncestorObject(AbstractProject.class)) != null) {
            ItemGroup context = p.getParent();
            Jenkins jenkins = Jenkins.getInstance();
            if (projectName.indexOf(36) < 0 && (jenkins == null || jenkins.getItem(projectName, context, Job.class) == null)) {
                projectName = "";
            }
        }
        this.project = projectName;
        this.setParameters(null);
        this.setFilter(null);
        this.setTarget(null);
        this.setExcludes(null);
        this.setSelector(DEFAULT_BUILD_SELECTOR);
        this.setFlatten(false);
        this.setOptional(false);
        this.setFingerprintArtifacts(false);
        this.setResultVariableSuffix(null);
    }

    @DataBoundSetter
    public void setParameters(String parameters) {
        this.parameters = Util.fixEmptyAndTrim((String)parameters);
    }

    @DataBoundSetter
    public void setFilter(String filter) {
        this.filter = Util.fixNull((String)filter).trim();
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.target = Util.fixNull((String)target).trim();
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = Util.fixNull((String)excludes).trim();
    }

    @DataBoundSetter
    public void setSelector(@Nonnull BuildSelector selector) {
        this.selector = selector;
    }

    @DataBoundSetter
    public void setFlatten(boolean flatten) {
        this.flatten = flatten ? Boolean.TRUE : null;
    }

    @DataBoundSetter
    public void setOptional(boolean optional) {
        this.optional = optional ? Boolean.TRUE : null;
    }

    @DataBoundSetter
    public void setFingerprintArtifacts(boolean fingerprintArtifacts) {
        this.doNotFingerprintArtifacts = !fingerprintArtifacts;
    }

    @DataBoundSetter
    public void setResultVariableSuffix(String resultVariableSuffix) {
        this.resultVariableSuffix = Util.fixEmptyAndTrim((String)resultVariableSuffix);
    }

    private static synchronized void setUpgradeNeeded() {
        if (!upgradeNeeded) {
            LOGGER.info("Upgrade for Copy Artifact is scheduled.");
            upgradeNeeded = true;
        }
    }

    private static List<CopyArtifact> getCopyArtifactsInProject(AbstractProject<?, ?> project) throws IOException {
        DescribableList list;
        Object object = project instanceof Project ? ((Project)project).getBuildersList() : (list = project instanceof MatrixProject ? ((MatrixProject)project).getBuildersList() : null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list.getAll(CopyArtifact.class);
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void upgradeCopyArtifact() {
        if (!upgradeNeeded) {
            return;
        }
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            LOGGER.log(Level.SEVERE, "Called for initializing, but Jenkins instance is unavailable.");
            return;
        }
        upgradeNeeded = false;
        boolean isUpgraded = false;
        for (AbstractProject project : jenkins.getAllItems(AbstractProject.class)) {
            try {
                for (CopyArtifact target : CopyArtifact.getCopyArtifactsInProject(project)) {
                    try {
                        if (!target.upgradeIfNecessary(project)) continue;
                        isUpgraded = true;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, String.format("Failed to upgrade CopyArtifact in %s", project.getFullName()), e);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, String.format("Failed to upgrade CopyArtifact in %s", project.getFullName()), e);
            }
        }
        if (!isUpgraded) {
            LOGGER.warning("Update of CopyArtifact is scheduled, but no CopyArtifact to upgrade was found!");
        }
    }

    public String getProjectName() {
        return this.project;
    }

    public String getParameters() {
        return this.parameters;
    }

    @Deprecated
    public BuildSelector getBuildSelector() {
        return this.selector;
    }

    public BuildSelector getSelector() {
        return this.selector;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isFlatten() {
        return this.flatten != null && this.flatten != false;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public String getResultVariableSuffix() {
        return this.resultVariableSuffix;
    }

    private boolean upgradeIfNecessary(AbstractProject<?, ?> job) throws IOException {
        if (this.isUpgradeNeeded()) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                LOGGER.log(Level.SEVERE, "upgrading copyartifact is required for {0} but Jenkins instance is unavailable", job.getDisplayName());
                return false;
            }
            int i = this.projectName.lastIndexOf(47);
            if (i != -1 && this.projectName.indexOf(61, i) != -1 && jenkins.getItem(this.projectName, job.getParent(), Job.class) == null) {
                this.project = this.projectName.substring(0, i);
                this.parameters = this.projectName.substring(i + 1);
            } else {
                this.project = this.projectName;
                this.parameters = null;
            }
            LOGGER.log(Level.INFO, "Split {0} into {1} with parameters {2}", new Object[]{this.projectName, this.project, this.parameters});
            this.projectName = null;
            job.save();
            return true;
        }
        return false;
    }

    private boolean isUpgradeNeeded() {
        return this.projectName != null;
    }

    public boolean isFingerprintArtifacts() {
        return !this.doNotFingerprintArtifacts;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new AbortException("Jenkins instance is unavailable.");
        }
        if (build instanceof AbstractBuild) {
            this.upgradeIfNecessary(((AbstractBuild)build).getProject());
        }
        EnvVars env = build.getEnvironment(listener);
        if (build instanceof AbstractBuild) {
            env.putAll(((AbstractBuild)build).getBuildVariables());
        } else {
            for (ParametersAction pa : build.getActions(ParametersAction.class)) {
                for (ParameterValue pv : pa.getParameters()) {
                    pv.buildEnvironment(build, env);
                }
            }
        }
        PrintStream console = listener.getLogger();
        String expandedProject = this.project;
        String expandedFilter = this.filter;
        String expandedExcludes = this.getExcludes();
        expandedProject = env.expand(this.project);
        Job job = (Job)jenkins.getItem(expandedProject, CopyArtifact.getItemGroup(build), Job.class);
        if (job != null && !expandedProject.equals(this.project) && !this.canReadFrom(job, build)) {
            job = null;
        }
        if (job == null) {
            throw new AbortException(Messages.CopyArtifact_MissingProject(expandedProject));
        }
        Run<?, ?> src = this.selector.getBuild(job, env, this.parameters != null ? new ParametersBuildFilter(env.expand(this.parameters)) : new BuildFilter(), build);
        if (src == null) {
            String message = Messages.CopyArtifact_MissingBuild(expandedProject);
            if (this.isOptional()) {
                console.println(message);
                return;
            }
            throw new AbortException(message);
        }
        FilePath targetDir = workspace;
        targetDir.mkdirs();
        EnvAction envData = (EnvAction)build.getAction(EnvAction.class);
        if (envData == null) {
            envData = new EnvAction();
            build.addAction((Action)envData);
        }
        envData.add(build, src, expandedProject, this.getResultVariableSuffix());
        if (this.target.length() > 0) {
            targetDir = new FilePath(targetDir, env.expand(this.target));
        }
        if ((expandedFilter = env.expand(this.filter)).trim().length() == 0) {
            expandedFilter = "**";
        }
        if (StringUtils.isBlank((String)(expandedExcludes = env.expand(expandedExcludes)))) {
            expandedExcludes = null;
        }
        if (jenkins.getPlugin("maven-plugin") != null && src instanceof MavenModuleSetBuild) {
            boolean ok = this.perform(src, build, expandedFilter, expandedExcludes, targetDir, listener);
            for (Run r : ((MavenModuleSetBuild)src).getModuleLastBuilds().values()) {
                ok |= this.perform(r, build, expandedFilter, expandedExcludes, targetDir, listener);
            }
            if (!ok) {
                throw new AbortException(Messages.CopyArtifact_FailedToCopy(expandedProject, expandedFilter));
            }
        } else if (src instanceof MatrixBuild) {
            boolean ok = false;
            for (Run r : ((MatrixBuild)src).getExactRuns()) {
                ok |= this.perform(r, build, expandedFilter, expandedExcludes, targetDir.child(r.getParent().getName()), listener);
            }
            if (!ok) {
                throw new AbortException(Messages.CopyArtifact_FailedToCopy(expandedProject, expandedFilter));
            }
        } else if (!this.perform(src, build, expandedFilter, expandedExcludes, targetDir, listener)) {
            throw new AbortException(Messages.CopyArtifact_FailedToCopy(expandedProject, expandedFilter));
        }
    }

    private boolean canReadFrom(Job<?, ?> job, Run<?, ?> build) {
        Job<?, ?> fromJob = job;
        Job toJob = build.getParent();
        if (CopyArtifactPermissionProperty.canCopyArtifact(CopyArtifact.getRootProject(toJob), CopyArtifact.getRootProject(fromJob))) {
            return true;
        }
        Authentication a = Jenkins.getAuthentication();
        if (!ACL.SYSTEM.equals(a)) {
            boolean b = job.getACL().hasPermission(Item.READ);
            if (!b) {
                LOGGER.fine(String.format("Refusing to copy artifact from %s to %s because %s lacks Item.READ access", job, build, a));
            }
            return b;
        }
        boolean b = job.getACL().hasPermission((Authentication)new UsernamePasswordAuthenticationToken((Object)"authenticated", (Object)"", new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY}), Item.READ);
        if (!b) {
            LOGGER.fine(String.format("Refusing to copy artifact from %s to %s because 'authenticated' lacks Item.READ access", job, build));
        }
        return b;
    }

    private static Job<?, ?> getRootProject(Job<?, ?> job) {
        if (job instanceof AbstractProject) {
            return ((AbstractProject)job).getRootProject();
        }
        return job;
    }

    private static ItemGroup getItemGroup(Run<?, ?> build) {
        return CopyArtifact.getRootProject(build.getParent()).getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean perform(Run src, Run<?, ?> dst, String expandedFilter, @CheckForNull String expandedExcludes, FilePath targetDir, TaskListener listener) throws IOException, InterruptedException {
        boolean bl;
        block12: {
            HashMap<String, String> fingerprintsShallow;
            PrintStream console = listener.getLogger();
            VirtualFile srcDir = this.selector.getArtifacts(src, console);
            if (srcDir == null) {
                return this.isOptional();
            }
            Map<String, String> fingerprints = null;
            try {
                fingerprints = CopyArtifact.copy(targetDir, srcDir, expandedFilter, expandedExcludes, this.isFingerprintArtifacts(), listener, this.isFlatten());
                int cnt = fingerprints.size();
                console.println(Messages.CopyArtifact_Copied(cnt, HyperlinkNote.encodeTo((String)('/' + src.getParent().getUrl()), (String)src.getParent().getFullDisplayName()), HyperlinkNote.encodeTo((String)('/' + src.getUrl()), (String)Integer.toString(src.getNumber()))));
                boolean bl2 = bl = cnt > 0 || this.isOptional();
                if (fingerprints == null) break block12;
                fingerprintsShallow = new HashMap<String, String>();
            }
            catch (Throwable throwable) {
                if (fingerprints != null) {
                    HashMap<String, String> fingerprintsShallow2 = new HashMap<String, String>();
                    FingerprintMap map = Jenkins.get().getFingerprintMap();
                    for (Map.Entry<String, String> entry : fingerprints.entrySet()) {
                        String name = entry.getKey().replaceFirst(".+/", "");
                        String digest = entry.getValue();
                        if (digest == null) continue;
                        fingerprintsShallow2.put(name, digest);
                        Fingerprint f = map.getOrCreate(src, name, digest);
                        f.addFor(src);
                        f.addFor(dst);
                    }
                    if (!fingerprintsShallow2.isEmpty()) {
                        for (Run r : new Run[]{src, dst}) {
                            Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)r.getAction(Fingerprinter.FingerprintAction.class);
                            if (fa != null) {
                                fa.add(fingerprintsShallow2);
                                continue;
                            }
                            r.addAction((Action)new Fingerprinter.FingerprintAction(r, fingerprintsShallow2));
                        }
                    }
                }
                throw throwable;
            }
            FingerprintMap map = Jenkins.get().getFingerprintMap();
            for (Map.Entry<String, String> entry : fingerprints.entrySet()) {
                String name = entry.getKey().replaceFirst(".+/", "");
                String digest = entry.getValue();
                if (digest == null) continue;
                fingerprintsShallow.put(name, digest);
                Fingerprint f = map.getOrCreate(src, name, digest);
                f.addFor(src);
                f.addFor(dst);
            }
            if (!fingerprintsShallow.isEmpty()) {
                for (Run r : new Run[]{src, dst}) {
                    Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)r.getAction(Fingerprinter.FingerprintAction.class);
                    if (fa != null) {
                        fa.add(fingerprintsShallow);
                        continue;
                    }
                    r.addAction((Action)new Fingerprinter.FingerprintAction(r, fingerprintsShallow));
                }
            }
        }
        return bl;
    }

    private static Map<String, String> copy(FilePath targetDir, VirtualFile srcDir, String expandedFilter, String expandedExcludes, boolean fingerprint, TaskListener listener, boolean flatten) throws IOException, InterruptedException {
        targetDir.mkdirs();
        Collection list = srcDir.list(expandedFilter.replace('\\', '/'), expandedExcludes != null ? expandedExcludes.replace('\\', '/') : null, false);
        HashMap<String, String> fingerprints = new HashMap<String, String>();
        for (String entry : list) {
            String digest = CopyArtifact.copyOne(srcDir.child(entry), new FilePath(targetDir, flatten ? entry.replaceFirst(".+/", "") : entry), fingerprint, listener);
            fingerprints.put(entry, digest);
        }
        return fingerprints;
    }

    private static MessageDigest md5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError((Object)x);
        }
    }

    private static String copyOne(VirtualFile s, FilePath d, boolean fingerprint, TaskListener listener) throws IOException, InterruptedException {
        String link = s.readLink();
        if (link != null) {
            d.getParent().mkdirs();
            d.symlinkTo(link, listener);
            return null;
        }
        try {
            byte[] digest;
            URL u = s.toExternalURL();
            if (u != null) {
                if (fingerprint) {
                    digest = (byte[])d.act((FilePath.FileCallable)new CopyURLWithFingerprinting(u, listener));
                } else {
                    new RobustHTTPClient().copyFromRemotely(d, u, listener);
                    digest = null;
                }
            } else if (fingerprint) {
                MessageDigest md5 = CopyArtifact.md5();
                try (InputStream is = s.open();
                     OutputStream os = d.write();){
                    IOUtils.copy((InputStream)is, (OutputStream)new DigestOutputStream(os, md5));
                }
                digest = md5.digest();
            } else {
                try (InputStream is = s.open();){
                    d.copyFrom(is);
                }
                digest = null;
            }
            try {
                d.touch(s.lastModified());
            }
            catch (IOException x) {
                LOGGER.warning(x.getMessage());
            }
            int mode = s.mode();
            if (mode != -1) {
                d.chmod(mode);
            }
            return digest != null ? Util.toHexString((byte[])digest) : null;
        }
        catch (IOException e) {
            throw new IOException("Failed to copy " + s + " to " + d, e);
        }
    }

    static boolean isValidVariableName(final String variableName) {
        if (StringUtils.isBlank((String)variableName)) {
            return false;
        }
        String expected = "GOOD";
        String expanded = Util.replaceMacro((String)String.format("${%s}", variableName), (VariableResolver)new VariableResolver<String>(){

            public String resolve(String name) {
                if (variableName.equals(name)) {
                    return "GOOD";
                }
                return null;
            }
        });
        return "GOOD".equals(expanded);
    }

    private static class EnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private EnvAction() {
        }

        @Nullable
        private String calculateDefaultSuffix(@Nonnull Run<?, ?> build, @Nonnull Run<?, ?> src, @Nonnull String projectName) {
            ItemGroup ctx = CopyArtifact.getItemGroup(build);
            Job item = src.getParent();
            String string = projectName = projectName.startsWith("/") ? item.getFullName() : item.getRelativeNameFrom(ctx);
            if (projectName == null) {
                LOGGER.log(Level.WARNING, "Failed to calculate a relative path of {0} from {2}", new Object[]{item.getFullName(), ctx.getFullName()});
                return null;
            }
            return projectName.toUpperCase().replaceAll("[^A-Z]+", "_");
        }

        private void add(@Nonnull Run<?, ?> build, @Nonnull Run<?, ?> src, @Nonnull String projectName, @Nullable String resultVariableSuffix) {
            if (this.data == null) {
                return;
            }
            if (!CopyArtifact.isValidVariableName(resultVariableSuffix) && (resultVariableSuffix = this.calculateDefaultSuffix(build, src, projectName)) == null) {
                return;
            }
            this.data.put(String.format("COPYARTIFACT_BUILD_NUMBER_%s", resultVariableSuffix), Integer.toString(src.getNumber()));
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    @Extension
    public static final class ListenerImpl
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            String oldFullName = Items.getCanonicalName((ItemGroup)item.getParent(), (String)oldName);
            String newFullName = Items.getCanonicalName((ItemGroup)item.getParent(), (String)newName);
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                LOGGER.log(Level.SEVERE, "Jenkins instance is no longer available.");
                return;
            }
            for (AbstractProject project : jenkins.getAllItems(AbstractProject.class)) {
                try {
                    for (CopyArtifact ca : ListenerImpl.getCopiers(project)) {
                        ItemGroup context;
                        String newProjectName;
                        String projectName = ca.getProjectName();
                        if (projectName == null) continue;
                        String suffix = "";
                        int i = projectName.indexOf(61);
                        if (i > 0) {
                            int end = projectName.substring(0, i).lastIndexOf(47);
                            suffix = projectName.substring(end);
                            projectName = projectName.substring(0, end);
                        }
                        if (projectName.equals(newProjectName = Items.computeRelativeNamesAfterRenaming((String)oldFullName, (String)newFullName, (String)projectName, (ItemGroup)(context = project.getParent())))) continue;
                        ca.project = newProjectName + suffix;
                        project.save();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(ListenerImpl.class.getName()).log(Level.WARNING, "Failed to resave project " + project.getName() + " for project rename in CopyArtifact build step (" + oldName + " =>" + newName + ")", ex);
                }
            }
        }

        private static List<CopyArtifact> getCopiers(AbstractProject<?, ?> project) throws IOException {
            List copiers = CopyArtifact.getCopyArtifactsInProject(project);
            for (CopyArtifact copier : copiers) {
                copier.upgradeIfNecessary(project);
            }
            return copiers;
        }
    }

    @Extension
    @Symbol(value={"copyArtifacts"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckProjectName(@AncestorInPath Job<?, ?> anc, @QueryParameter String value) {
            Job nearest;
            if (anc == null) {
                return FormValidation.ok((String)Messages.CopyArtifact_AncestorIsNull());
            }
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return FormValidation.ok();
            }
            Item item = jenkins.getItem(value, anc.getParent());
            FormValidation result = item != null ? (jenkins.getPlugin("maven-plugin") != null && item instanceof MavenModuleSet ? FormValidation.warning((String)Messages.CopyArtifact_MavenProject()) : (item instanceof MatrixProject ? FormValidation.warning((String)Messages.CopyArtifact_MatrixProject()) : FormValidation.ok())) : (value.indexOf(36) >= 0 ? FormValidation.warning((String)Messages.CopyArtifact_ParameterizedName()) : ((nearest = (Job)Items.findNearest(Job.class, (String)value, (ItemGroup)anc.getParent())) != null ? FormValidation.error((String)Messages.BuildTrigger_NoSuchProject(value, nearest.getName())) : FormValidation.error((String)Messages.BuildTrigger_NoProjectSpecified())));
            return result;
        }

        public FormValidation doCheckResultVariableSuffix(@QueryParameter String value) {
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if (!CopyArtifact.isValidVariableName(value)) {
                return FormValidation.error((String)Messages.CopyArtifact_InvalidVariableName());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public String getDisplayName() {
            return Messages.CopyArtifact_DisplayName();
        }
    }

    private static class CopyURLWithFingerprinting
    extends MasterToSlaveFileCallable<byte[]> {
        private static final long serialVersionUID = 1L;
        private final URL u;
        private final TaskListener listener;
        private final RobustHTTPClient client = new RobustHTTPClient();

        CopyURLWithFingerprinting(URL u, TaskListener listener) {
            this.u = u;
            this.listener = listener;
        }

        public byte[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            hudson.util.IOUtils.mkdirs((File)f.getParentFile());
            MessageDigest md5 = CopyArtifact.md5();
            this.client.connect("download", "download " + RobustHTTPClient.sanitize((URL)this.u) + " to " + f, c -> c.execute((HttpUriRequest)new HttpGet(this.u.toString())), response -> {
                try (InputStream is = response.getEntity().getContent();
                     FileOutputStream os = new FileOutputStream(f);){
                    IOUtils.copy((InputStream)is, (OutputStream)new DigestOutputStream(os, md5));
                }
            }, this.listener);
            return md5.digest();
        }
    }

    public static class ConverterImpl
    extends XStream2.PassthruConverter<CopyArtifact> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(CopyArtifact obj, UnmarshallingContext context) {
            if (obj.selector == null) {
                obj.selector = new StatusBuildSelector(obj.stable != null && obj.stable != false);
                OldDataMonitor.report((UnmarshallingContext)context, (String)"1.355");
            }
            if (obj.isUpgradeNeeded()) {
                CopyArtifact.setUpgradeNeeded();
            }
        }
    }
}

