/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Fingerprint;
import hudson.model.FingerprintMap;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.os.PosixException;
import hudson.plugins.copyartifact.Copier;
import hudson.tasks.Fingerprinter;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Deprecated
@Extension(ordinal=-100.0)
public class FingerprintingCopyMethod
extends Copier {
    private static final Logger LOGGER = Logger.getLogger(FingerprintingCopyMethod.class.getName());
    private Run<?, ?> src;
    private Run<?, ?> dst;
    private final MessageDigest md5 = this.newMD5();
    private final Map<String, String> fingerprints = new HashMap<String, String>();

    @Override
    public void initialize(Run<?, ?> src, Run<?, ?> dst, FilePath srcDir, FilePath baseTargetDir) throws IOException, InterruptedException {
        this.src = src;
        this.dst = dst;
        this.fingerprints.clear();
    }

    private MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int copyAll(FilePath srcDir, String filter, String excludes, FilePath targetDir, boolean fingerprintArtifacts) throws IOException, InterruptedException {
        FilePath[] list;
        targetDir.mkdirs();
        for (FilePath file : list = srcDir.list(filter, excludes, false)) {
            String tail = file.getRemote().substring(srcDir.getRemote().length());
            if (tail.startsWith("\\") || tail.startsWith("/")) {
                tail = tail.substring(1);
            }
            this.copyOne(file, new FilePath(targetDir, tail), fingerprintArtifacts);
        }
        return list.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyOne(FilePath s, FilePath d, boolean fingerprintArtifacts) throws IOException, InterruptedException {
        String link = s.readLink();
        if (link != null) {
            d.getParent().mkdirs();
            d.symlinkTo(link, TaskListener.NULL);
            return;
        }
        try {
            this.md5.reset();
            try (DigestOutputStream out = new DigestOutputStream(d.write(), this.md5);){
                s.copyTo((OutputStream)out);
            }
            try {
                d.chmod(s.mode());
            }
            catch (PosixException x) {
                LOGGER.log(Level.WARNING, "could not check mode of " + s, x);
            }
            try {
                d.touch(s.lastModified());
            }
            catch (IOException x) {
                LOGGER.warning(x.getMessage());
            }
            String digest = Util.toHexString((byte[])this.md5.digest());
            if (fingerprintArtifacts) {
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    throw new AbortException("Jenkins instance no longer exists.");
                }
                FingerprintMap map = jenkins.getFingerprintMap();
                Fingerprint f = map.getOrCreate(this.src, s.getName(), digest);
                if (this.src != null) {
                    f.addFor(this.src);
                }
                if (this.dst != null) {
                    f.addFor(this.dst);
                }
                this.fingerprints.put(s.getName(), digest);
            }
        }
        catch (IOException e) {
            throw new IOException2("Failed to copy " + s + " to " + d, (Throwable)e);
        }
    }

    @Override
    public void end() {
        for (Run r : new Run[]{this.src, this.dst}) {
            if (r == null || this.fingerprints.size() <= 0) continue;
            Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)r.getAction(Fingerprinter.FingerprintAction.class);
            if (fa != null) {
                fa.add(this.fingerprints);
                continue;
            }
            r.getActions().add(new Fingerprinter.FingerprintAction(r, this.fingerprints));
        }
    }

    @Override
    @SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"}, justification="This is a method not of Cloneable but of Copier.")
    public Copier clone() {
        return new FingerprintingCopyMethod();
    }
}

