/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.BuildFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParametersBuildFilter
extends BuildFilter {
    private List<StringParameterValue> filters = new ArrayList<StringParameterValue>(5);
    private static final Pattern PARAMVAL_PATTERN = Pattern.compile("(.*?)=([^,]*)(,|$)");

    public ParametersBuildFilter(String paramsToMatch) {
        Matcher m = PARAMVAL_PATTERN.matcher(paramsToMatch);
        while (m.find()) {
            this.filters.add(new StringParameterValue(m.group(1), m.group(2)));
        }
    }

    public boolean isValid(Job<?, ?> job) {
        if (this.filters.isEmpty()) {
            return false;
        }
        block3: for (Run run = job.getLastCompletedBuild(); run != null; run = run.getPreviousCompletedBuild()) {
            try {
                EnvVars env = run.getEnvironment(TaskListener.NULL);
                for (StringParameterValue spv : this.filters) {
                    if (env.containsKey((Object)spv.getName())) continue;
                    continue block3;
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isSelectable(Run<?, ?> run, EnvVars env) {
        EnvVars otherEnv;
        try {
            otherEnv = run.getEnvironment(TaskListener.NULL);
        }
        catch (Exception ex) {
            return false;
        }
        if (!(run instanceof AbstractBuild)) {
            for (ParametersAction pa : run.getActions(ParametersAction.class)) {
                for (ParameterValue pv : pa.getParameters()) {
                    pv.buildEnvironment(run, otherEnv);
                }
            }
        }
        for (StringParameterValue spv : this.filters) {
            if (Objects.equals(spv.getValue(), otherEnv.get((Object)spv.getName()))) continue;
            return false;
        }
        return true;
    }
}

