/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class TriggeredBuildSelector
extends BuildSelector {
    private static final Logger LOGGER = Logger.getLogger(TriggeredBuildSelector.class.getName());
    private Boolean fallbackToLastSuccessful;
    private UpstreamFilterStrategy upstreamFilterStrategy;
    private boolean allowUpstreamDependencies;

    @DataBoundConstructor
    public TriggeredBuildSelector() {
        this(false);
    }

    @Deprecated
    public TriggeredBuildSelector(boolean fallbackToLastSuccessful, UpstreamFilterStrategy upstreamFilterStrategy, boolean allowUpstreamDependencies) {
        this.setFallbackToLastSuccessful(fallbackToLastSuccessful);
        this.setUpstreamFilterStrategy(upstreamFilterStrategy);
        this.allowUpstreamDependencies = allowUpstreamDependencies;
    }

    @Deprecated
    public TriggeredBuildSelector(boolean fallbackToLastSuccessful, UpstreamFilterStrategy upstreamFilterStrategy) {
        this(fallbackToLastSuccessful, upstreamFilterStrategy, false);
    }

    @Deprecated
    public TriggeredBuildSelector(boolean fallback) {
        this(fallback, UpstreamFilterStrategy.UseGlobalSetting, false);
    }

    public boolean isFallbackToLastSuccessful() {
        return this.fallbackToLastSuccessful != null && this.fallbackToLastSuccessful != false;
    }

    @DataBoundSetter
    public void setFallbackToLastSuccessful(boolean fallbackToLastSuccessful) {
        this.fallbackToLastSuccessful = fallbackToLastSuccessful ? Boolean.TRUE : null;
    }

    public UpstreamFilterStrategy getUpstreamFilterStrategy() {
        return this.upstreamFilterStrategy;
    }

    @DataBoundSetter
    public void setUpstreamFilterStrategy(UpstreamFilterStrategy upstreamFilterStrategy) {
        this.upstreamFilterStrategy = upstreamFilterStrategy;
    }

    public boolean isUseNewest() {
        UpstreamFilterStrategy strategy = this.getUpstreamFilterStrategy();
        if (strategy == null || strategy == UpstreamFilterStrategy.UseGlobalSetting) {
            strategy = ((DescriptorImpl)this.getDescriptor()).getGlobalUpstreamFilterStrategy();
        }
        if (strategy == null) {
            return false;
        }
        switch (strategy) {
            case UseOldest: {
                return false;
            }
            case UseNewest: {
                return true;
            }
        }
        return false;
    }

    public boolean isAllowUpstreamDependencies() {
        return this.allowUpstreamDependencies;
    }

    @DataBoundSetter
    public void setAllowUpstreamDependencies(boolean allowUpstreamDependencies) {
        this.allowUpstreamDependencies = allowUpstreamDependencies;
    }

    @Override
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        Run<?, ?> result = null;
        ArrayList<String> jobNames = new ArrayList<String>();
        jobNames.add(job.getFullName());
        if (job instanceof AbstractProject && ((AbstractProject)job).getRootProject() != job) {
            jobNames.add(((AbstractProject)job).getRootProject().getFullName());
        }
        ArrayList<Object> upstreamBuilds = new ArrayList<Object>();
        for (Cause cause : parent.getCauses()) {
            Object upstream;
            Run run;
            if (!(cause instanceof Cause.UpstreamCause) || (run = (upstream = (Cause.UpstreamCause)cause).getUpstreamRun()) == null) continue;
            upstreamBuilds.add(run);
        }
        if (this.isAllowUpstreamDependencies() && parent instanceof AbstractBuild) {
            AbstractBuild parentBuild = (AbstractBuild)parent;
            Map map = parentBuild.getUpstreamBuilds();
            for (Map.Entry entry : map.entrySet()) {
                upstreamBuilds.add(((AbstractProject)entry.getKey()).getBuildByNumber(((Integer)entry.getValue()).intValue()));
            }
        }
        for (Run run : upstreamBuilds) {
            Run<?, ?> run2 = null;
            run2 = jobNames.contains(run.getParent().getFullName()) ? job.getBuildByNumber(run.getNumber()) : this.getBuild(job, env, filter, run);
            if (run2 == null || !filter.isSelectable(run2, env) || result != null && (!this.isUseNewest() || result.getNumber() >= run2.getNumber()) && (this.isUseNewest() || result.getNumber() <= run2.getNumber())) continue;
            result = run2;
        }
        if (result == null && this.isFallbackToLastSuccessful()) {
            result = super.getBuild(job, env, filter, parent);
        }
        return result;
    }

    @Override
    protected boolean isSelectable(Run<?, ?> run, EnvVars env) {
        return this.isFallbackToLastSuccessful() && TriggeredBuildSelector.isBuildResultBetterOrEqualTo(run, Result.SUCCESS);
    }

    @Extension(ordinal=25.0)
    @Symbol(value={"upstream"})
    public static class DescriptorImpl
    extends SimpleBuildSelectorDescriptor {
        private UpstreamFilterStrategy globalUpstreamFilterStrategy = UpstreamFilterStrategy.UseOldest;

        public DescriptorImpl() {
            super(TriggeredBuildSelector.class, Messages._TriggeredBuildSelector_DisplayName());
            this.load();
        }

        public void setGlobalUpstreamFilterStrategy(UpstreamFilterStrategy globalUpstreamFilterStrategy) {
            this.globalUpstreamFilterStrategy = globalUpstreamFilterStrategy;
        }

        public UpstreamFilterStrategy getGlobalUpstreamFilterStrategy() {
            return this.globalUpstreamFilterStrategy;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setGlobalUpstreamFilterStrategy(UpstreamFilterStrategy.valueOf(json.getString("globalUpstreamFilterStrategy")));
            this.save();
            return super.configure(req, json);
        }
    }

    public static enum UpstreamFilterStrategy {
        UseGlobalSetting(false, Messages._TriggeredBuildSelector_UpstreamFilterStrategy_UseGlobalSetting()),
        UseOldest(true, Messages._TriggeredBuildSelector_UpstreamFilterStrategy_UseOldest()),
        UseNewest(true, Messages._TriggeredBuildSelector_UpstreamFilterStrategy_UseNewest());

        private final boolean forGlobalSetting;
        private final Localizable displayName;

        private UpstreamFilterStrategy(boolean forGlobalSetting, Localizable displayName) {
            this.forGlobalSetting = forGlobalSetting;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }

        public boolean isForGlobalSetting() {
            return this.forGlobalSetting;
        }
    }
}

